/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.helpers;

import de.fzj.unicore.uas.client.TSFClient;
import de.fzj.unicore.uas.client.TSSClient;
import de.fzj.unicore.ucc.Command;
import de.fzj.unicore.ucc.MessageWriter;
import de.fzj.unicore.ucc.helpers.GridTask;
import de.fzj.unicore.ucc.helpers.GridTaskResult;
import de.fzj.unicore.ucc.helpers.GridTaskTarget;
import de.fzj.unicore.ucc.helpers.TargetSystemFactoryLister;
import de.fzj.unicore.wsrflite.xmlbeans.client.IRegistryQuery;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.oasisOpen.docs.wsrf.rl2.TerminationTimeDocument;
import org.unigrids.x2006.x04.services.tsf.CreateTSRDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class Connector
implements Runnable {
    private final IRegistryQuery registry;
    private final IClientConfiguration securityProperties;
    private final MessageWriter msg;
    final AtomicInteger tsfAvailable = new AtomicInteger(0);
    final AtomicInteger tssAvailable = new AtomicInteger(0);
    private String blackList;
    private int initialLifeTime;
    private int timeout = 10;

    public Connector(IRegistryQuery registry, IClientConfiguration properties, MessageWriter msg) {
        this.registry = registry;
        this.securityProperties = properties;
        this.msg = msg;
    }

    @Override
    public void run() {
        TargetSystemFactoryLister lister = new TargetSystemFactoryLister(this.registry, this.securityProperties, this.msg);
        if (this.blackList != null) {
            this.msg.verbose("Using blacklist <" + this.blackList + ">");
            String[] blacklist = this.blackList.trim().split(" ");
            lister.setBlacklist(blacklist);
        }
        GridTask<Boolean> task = new GridTask<Boolean>(){

            public TSFClient createClient(GridTaskTarget<Boolean> worker) throws Exception {
                EndpointReferenceType epr = worker.getEpr();
                return new TSFClient(epr.getAddress().getStringValue(), epr, Connector.this.securityProperties);
            }

            @Override
            public Boolean run(GridTaskTarget<Boolean> worker) throws Exception {
                block6: {
                    Connector.this.msg.verbose("Connecting to " + worker.getEpr().getAddress().getStringValue());
                    TSFClient tsf = this.createClient(worker);
                    Connector.this.tsfAvailable.incrementAndGet();
                    List eprs = tsf.getAccessibleTargetSystems();
                    if (eprs == null || eprs.size() == 0) {
                        try {
                            CreateTSRDocument in = CreateTSRDocument.Factory.newInstance();
                            in.addNewCreateTSR();
                            if (Connector.this.initialLifeTime > 0) {
                                TerminationTimeDocument.TerminationTime tt = TerminationTimeDocument.TerminationTime.Factory.newInstance();
                                tt.setCalendarValue(Connector.this.getTermTime());
                                in.getCreateTSR().setTerminationTime(tt);
                            }
                            TSSClient tss = tsf.createTSS(in);
                            Connector.this.msg.verbose("Created TSS <" + tss.getTargetSystemName() + "> at address " + tss.getEPR().getAddress().getStringValue());
                            Connector.this.tssAvailable.incrementAndGet();
                        }
                        catch (Exception e) {
                            if (Command.getDetailMessage(e).contains("Access denied")) {
                                Connector.this.msg.verbose("Access denied on <" + tsf.getEPR().getAddress().getStringValue() + ">");
                                break block6;
                            }
                            Connector.this.msg.error("Can't create target system.", e);
                        }
                    } else {
                        Connector.this.tssAvailable.addAndGet(eprs.size());
                    }
                }
                return Boolean.TRUE;
            }
        };
        try {
            List results = lister.runOnEachTSF(task);
            GridTaskResult.completeAsyncTasks(results, this.timeout, this.msg);
        }
        catch (Exception ex) {
            this.msg.error("Error setting up connect tasks.", ex);
        }
    }

    protected Calendar getTermTime() {
        Calendar c = Calendar.getInstance();
        c.add(5, this.initialLifeTime);
        return c;
    }

    public void setInitialLifetime(int days) {
        if (days < 0) {
            throw new IllegalArgumentException();
        }
        this.initialLifeTime = days;
    }

    public void setBlacklist(String blackList) {
        this.blackList = blackList;
    }

    public void setTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException();
        }
        this.timeout = timeout;
    }

    public int getAvailableTSS() {
        return this.tssAvailable.get();
    }

    public int getAvailableTSF() {
        return this.tsfAvailable.get();
    }
}

