/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.helpers;

import de.fzj.unicore.ucc.helpers.ResourceCache;
import de.fzj.unicore.wsrflite.xfire.ClientException;
import de.fzj.unicore.wsrflite.xmlbeans.client.IRegistryQuery;
import java.util.List;
import javax.xml.namespace.QName;
import org.oasisOpen.docs.wsrf.sg2.EntryType;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class CachingRegistryClient
implements IRegistryQuery {
    private static final String SERVICES = "services-cache";
    private static final String ACCESSIBLE_SERVICES = "accessible-services-cache";
    private final ResourceCache cache;
    private final IRegistryQuery registry;
    private volatile int count = 0;

    public CachingRegistryClient(IRegistryQuery registry) {
        this.registry = registry;
        this.cache = ResourceCache.getInstance();
    }

    public synchronized List<EndpointReferenceType> listAccessibleServices(QName porttype) throws Exception {
        ++this.count;
        List result = this.cache.getAs(ACCESSIBLE_SERVICES, porttype, List.class);
        if (result != null) {
            return result;
        }
        result = this.registry.listAccessibleServices(porttype);
        this.cache.put(ACCESSIBLE_SERVICES, porttype, result);
        return result;
    }

    public synchronized List<EndpointReferenceType> listServices(QName porttype) throws Exception {
        ++this.count;
        List result = this.cache.getAs(SERVICES, porttype, List.class);
        if (result != null) {
            return result;
        }
        result = this.registry.listServices(porttype);
        this.cache.put(SERVICES, porttype, result);
        return result;
    }

    public int getNumberOfRegistryLookups() {
        return this.count;
    }

    public boolean checkConnection() throws ClientException {
        return this.registry.checkConnection();
    }

    public boolean checkConnection(int timeout) throws ClientException {
        return this.registry.checkConnection(timeout);
    }

    public String getConnectionStatus() throws ClientException {
        return this.registry.getConnectionStatus();
    }

    public List<EntryType> listEntries() throws Exception {
        return this.registry.listEntries();
    }

    public List<EndpointReferenceType> listServices(QName porttype, IRegistryQuery.ServiceListFilter acceptFilter) throws Exception {
        return this.registry.listServices(porttype, acceptFilter);
    }
}

