/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.helpers;

import de.fzj.unicore.ucc.util.VOAttributeFilter;
import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.emi.security.authn.x509.impl.X500NameUtils;
import eu.unicore.samly2.assertion.Assertion;
import eu.unicore.samly2.exceptions.SAMLParseException;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.net.MalformedURLException;
import org.apache.log4j.Logger;
import pl.edu.icm.unicore.uvos.api.Group;
import pl.edu.icm.unicore.uvos.api.Identity;
import pl.edu.icm.unicore.uvos.api.IdentityType;
import pl.edu.icm.unicore.uvos.api.exceptions.AttributeNotFoundException;
import pl.edu.icm.unicore.uvos.util.AttributeFilter;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.UnsupportedSAMLException;
import pl.edu.icm.unicore.uvos.wsclient.samlapi.InvalidSignatureException;
import pl.edu.icm.unicore.uvos.wsclient.samlapi.InvocationException;
import pl.edu.icm.unicore.uvos.wsclient.samlapi.SAMLErrorResponseException;
import pl.edu.icm.unicore.uvos.wsclient.samlapi.SAMLVOQueryClient;
import pl.edu.icm.unicore.uvos.wsclient.samlapi.SecuritySetupException;

public class AttributeAssertionFetcher {
    private static final Logger logger = Logger.getLogger((String)AttributeAssertionFetcher.class.getCanonicalName());
    private final IClientConfiguration cfg;
    private final SAMLVOQueryClient client;

    public AttributeAssertionFetcher(IClientConfiguration cfg, String voURL) throws SecuritySetupException, MalformedURLException {
        this.client = new SAMLVOQueryClient(voURL, cfg);
        this.client.setDSigPolicy(false, true, null, (X509CertChainValidator)cfg.getValidator());
        this.cfg = cfg;
    }

    public Assertion fetchAssertion(String scope, VOAttributeFilter attributeFilter) throws SAMLErrorResponseException, AttributeNotFoundException, SAMLParseException, UnsupportedSAMLException, InvalidSignatureException, InvocationException {
        String userDn = this.cfg.getCredential().getSubjectName();
        logger.trace((Object)("User identity: " + X500NameUtils.getReadableForm((String)userDn)));
        Group ggroup = null;
        if (scope != null) {
            ggroup = new Group(scope);
            logger.debug((Object)("Assuming group " + scope));
        } else {
            logger.debug((Object)"Scope (group) was not selected, fetching attributes from all groups");
        }
        Identity identity = new Identity(IdentityType.DN, userDn);
        Assertion a = this.client.getFilteredAssertion(identity, ggroup, true, (AttributeFilter)attributeFilter);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Attribute assertion fetched:");
            logger.trace((Object)a.getXML().toString());
        }
        return a;
    }
}

