/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.authn;

import de.fzj.unicore.ucc.Constants;
import de.fzj.unicore.ucc.authn.Authentication;
import eu.unicore.security.canl.CachingPasswordCallback;
import eu.unicore.security.canl.CredentialProperties;
import eu.unicore.security.canl.PasswordCallback;
import eu.unicore.security.canl.TruststoreProperties;
import eu.unicore.util.configuration.PropertyMD;
import eu.unicore.util.httpclient.ClientProperties;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Properties;
import jline.ConsoleReader;

public class KeystoreAuthN
implements Authentication,
Constants {
    public static final String X509 = "X509";

    @Override
    public String getName() {
        return X509;
    }

    @Override
    public String getDescription() {
        return "Uses a local keystore and optional truststore file.";
    }

    @Override
    public IClientConfiguration initSecurityProperties(Properties properties) {
        String logIn;
        ClientProperties sp = new ClientProperties(properties, this.getPasswordCallback(), "truststore.", "credential.", "client.");
        String logOut = properties.getProperty("log.outgoing");
        if (logOut != null) {
            sp.getExtraSettings().setProperty("log.outgoing", logOut);
        }
        if ((logIn = properties.getProperty("log.incoming")) != null) {
            sp.getExtraSettings().setProperty("log.incoming", logIn);
        }
        return sp;
    }

    @Override
    public void printUsage() {
        PropertyMD prop;
        System.out.println("The following properties can be used in the UCC preference file to configure the X509 authentication. Many of these are optional. Refer to the manual and/or the example files.");
        System.out.println();
        System.out.println("For configuring your credential: ");
        for (Map.Entry<String, PropertyMD> entry : this.getMeta(CredentialProperties.class).entrySet()) {
            prop = entry.getValue();
            if (prop.isHidden()) continue;
            System.out.println("credential." + entry.getKey() + " : " + prop.getDescription());
        }
        System.out.println();
        System.out.println("For configuring your trusted CAs and certificates: ");
        for (Map.Entry<String, PropertyMD> entry : this.getMeta(TruststoreProperties.class).entrySet()) {
            prop = entry.getValue();
            if (prop.isHidden()) continue;
            System.out.println("truststore." + entry.getKey() + " : " + prop.getDescription());
        }
    }

    private PasswordCallback getPasswordCallback() {
        return new CachingPasswordCallback(){

            public boolean ignoreProperties() {
                return false;
            }

            public char[] getPasswordFromUser(String protectedArtifactType, String protectedArtifactDescription) {
                String r;
                System.out.println("Please enter your " + protectedArtifactType + " (" + protectedArtifactDescription + ") password: ");
                try {
                    r = KeystoreAuthN.this.readFromStdin();
                }
                catch (IOException e) {
                    return null;
                }
                r.trim();
                return r.toCharArray();
            }

            public boolean askForSeparateKeyPassword() {
                return false;
            }
        };
    }

    private String readFromStdin() throws IOException {
        return new ConsoleReader().readLine(new Character('*'));
    }

    private Map<String, PropertyMD> getMeta(Class<?> props) {
        try {
            Field f = props.getDeclaredField("META");
            f.setAccessible(true);
            return (Map)f.get(null);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }
}

