/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.actions;

import de.fzj.unicore.uas.client.BaseUASClient;
import de.fzj.unicore.ucc.actions.ActionBase;
import de.fzj.unicore.ucc.util.UnitParser;
import java.util.Calendar;
import java.util.Date;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class WSRF
extends ActionBase {
    protected BaseUASClient wsrf;
    private static String lastProperties;

    @Override
    public void process() {
        block8: {
            super.process();
            try {
                int length = this.getCommandLine().getArgs().length;
                if (length < 2) {
                    throw new IllegalArgumentException("You must provide at least a WSRF command as argument.");
                }
                String cmd = this.getCommandLine().getArgs()[1];
                if (length < 3) {
                    throw new IllegalArgumentException("You must provide a URL as argument to this command.");
                }
                String url = this.getCommandLine().getArgs()[length - 1];
                EndpointReferenceType epr = EndpointReferenceType.Factory.newInstance();
                epr.addNewAddress().setStringValue(url);
                this.wsrf = new BaseUASClient(url, epr, this.securityProperties);
                this.verbose("Connecting to <" + url + ">");
                if ("getproperties".startsWith(cmd)) {
                    this.doGetProperties();
                    break block8;
                }
                if ("destroy".startsWith(cmd)) {
                    this.doDestroy();
                    break block8;
                }
                if ("extend".startsWith(cmd)) {
                    Integer days = Integer.parseInt(this.getCommandLine().getArgs()[2]);
                    this.doExtendLifetime(days);
                    break block8;
                }
                if ("setterminationtime".startsWith(cmd)) {
                    this.doSetTT();
                    break block8;
                }
                throw new IllegalArgumentException("Command <" + cmd + "> not understood!");
            }
            catch (Exception e) {
                this.error("Can't perform wsrf operation", e);
                this.endProcessing(1);
            }
        }
    }

    @Override
    protected boolean requireRegistry() {
        return false;
    }

    protected void doGetProperties() throws Exception {
        String props = this.wsrf.getResourcePropertyDocument();
        this.message(props);
        lastProperties = props;
    }

    protected void doDestroy() throws Exception {
        this.wsrf.destroy();
        this.verbose("Destroyed resource.");
    }

    protected void doSetTT() throws Exception {
        String dString = this.getCommandLine().getArgs()[2];
        Date d = UnitParser.extractDateTime(dString);
        Calendar newTT = Calendar.getInstance();
        newTT.setTime(d);
        this.wsrf.setTerminationTime(newTT);
        this.verbose("Set termination time to '" + dString + "'");
    }

    protected void doExtendLifetime(int days) throws Exception {
        Calendar tt = this.wsrf.getTerminationTime();
        tt.add(5, days);
        this.wsrf.setTerminationTime(tt);
        this.verbose("Extended termination time by <" + days + "> days.");
    }

    @Override
    public String getName() {
        return "wsrf";
    }

    @Override
    public String getArgumentList() {
        return "[getproperties | destroy | extend <days> | setterminationtime <'yyyy-MM-dd HH:mm'|'HH:mm'> ] URL";
    }

    @Override
    public String getSynopsis() {
        return "Perform a lowlevel WSRF operation such as getProperties() or destroy() on the resource at <URL>";
    }

    @Override
    public String getDescription() {
        return "perform a WSRF operation";
    }

    static String getLastProperties() {
        return lastProperties;
    }
}

