/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.actions;

import de.fzj.unicore.ucc.UCCOptions;
import de.fzj.unicore.ucc.actions.ActionBase;
import de.fzj.unicore.ucc.helpers.EndProcessingException;
import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.client.BaseWSRFClient;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.oasisOpen.docs.wsrf.rp2.UpdateResourcePropertiesDocument;
import org.oasisOpen.docs.wsrf.rp2.UpdateType;
import org.unigrids.services.atomic.types.UmaskDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class Umask
extends ActionBase {
    public static final String OPT_SET_LONG = "set";
    public static final String OPT_SET = "s";

    @Override
    protected void createOptions() {
        super.createOptions();
        UCCOptions uCCOptions = this.getOptions();
        OptionBuilder.withLongOpt((String)OPT_SET_LONG);
        OptionBuilder.withDescription((String)"Set a umask to the provided value.");
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.hasArg();
        uCCOptions.addOption(OptionBuilder.create((String)OPT_SET));
    }

    @Override
    public String getName() {
        return "umask";
    }

    @Override
    public String getSynopsis() {
        return "Get or set umask of a remote storage (SMS) or a target system service (TSS). Umask is used by the UNICORE server side to control permissions of newly created files. Without the 'set' parameter the current umask is printed.";
    }

    @Override
    public String getDescription() {
        return "get or set a file creation umask";
    }

    @Override
    public String getArgumentList() {
        return "<Storage-URL | TargetSystem-URL>";
    }

    @Override
    public String getCommandGroup() {
        return "Data management";
    }

    @Override
    public void process() {
        UmaskDocument umaskDoc;
        String umaskDocS;
        super.process();
        String set = this.getOption(OPT_SET_LONG, OPT_SET);
        if (set != null) {
            this.verbose("Will set a umask to " + set);
        } else {
            this.verbose("Will get a umask");
        }
        CommandLine cmdLine = this.getCommandLine();
        if (cmdLine.getArgs().length != 2) {
            this.error("Wrong number of arguments", null);
            this.printUsage();
            this.endProcessing(2);
        }
        String url = cmdLine.getArgs()[1];
        this.verbose("Operating on a address: " + url);
        BaseWSRFClient client = this.createWSRFClient(url);
        try {
            umaskDocS = client.getResourceProperty(UmaskDocument.type.getDocumentElementName());
        }
        catch (Exception ex) {
            this.error("Error getting WS-RP document. It seems that the selected service doesn't support umask setting", ex);
            this.endProcessing(1);
            return;
        }
        if (umaskDocS == null) {
            this.error("The selected service doesn't support umask setting", null);
            this.endProcessing(1);
        }
        try {
            umaskDoc = UmaskDocument.Factory.parse((String)umaskDocS);
        }
        catch (XmlException e) {
            this.error("The received resource property has invalid format. Perhaps the service version is incompatible with this client.", e);
            this.endProcessing(1);
            return;
        }
        if (set == null) {
            this.message(umaskDoc.getUmask());
        } else {
            UpdateResourcePropertiesDocument reqDoc = UpdateResourcePropertiesDocument.Factory.newInstance();
            UpdateResourcePropertiesDocument.UpdateResourceProperties req = reqDoc.addNewUpdateResourceProperties();
            UpdateType update = req.addNewUpdate();
            umaskDoc = UmaskDocument.Factory.newInstance();
            umaskDoc.setUmask(set);
            WSUtilities.insertAny((XmlObject)umaskDoc, (XmlObject)update);
            try {
                client.getRP().UpdateResourceProperties(reqDoc);
            }
            catch (Exception e) {
                this.error("Error updateing umask WSRP.", e);
                this.endProcessing(1);
            }
        }
    }

    private BaseWSRFClient createWSRFClient(String url) {
        EndpointReferenceType e = EndpointReferenceType.Factory.newInstance();
        e.addNewAddress().setStringValue(url);
        try {
            String dn = this.findServerName(e);
            if (dn != null) {
                WSUtilities.addServerIdentity((EndpointReferenceType)e, (String)dn);
            }
            BaseWSRFClient client = new BaseWSRFClient(url, e, this.securityProperties);
            return client;
        }
        catch (Exception ee) {
            this.error("Can't create client for " + url, ee);
            this.endProcessing(1);
            throw new EndProcessingException(1);
        }
    }
}

