/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.actions;

import de.fzj.unicore.ucc.Command;
import de.fzj.unicore.ucc.IServiceInfoProvider;
import de.fzj.unicore.ucc.UCC;
import de.fzj.unicore.ucc.UCCOptions;
import de.fzj.unicore.ucc.actions.ActionBase;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.cli.OptionBuilder;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class SystemInfo
extends ActionBase {
    private boolean details = false;

    @Override
    protected void createOptions() {
        super.createOptions();
        UCCOptions uCCOptions = this.getOptions();
        OptionBuilder.withLongOpt((String)"long");
        OptionBuilder.withDescription((String)"Detailed output.");
        OptionBuilder.isRequired((boolean)false);
        uCCOptions.addOption(OptionBuilder.create((String)"l"));
    }

    @Override
    public String getName() {
        return "system-info";
    }

    @Override
    public String getDescription() {
        return "check the availability of services";
    }

    @Override
    public String getCommandGroup() {
        return "General";
    }

    @Override
    public String getSynopsis() {
        return "Checks the registry for the availability of UNICORE services. If the '-l' option is used, the address of the found service is printed";
    }

    @Override
    public void process() {
        super.process();
        this.details = this.getBooleanOption("long", "l");
        this.getInfo();
    }

    protected void getInfo() {
        for (Command c : UCC.getAllCommands()) {
            if (!(c instanceof IServiceInfoProvider)) continue;
            IServiceInfoProvider info = (IServiceInfoProvider)((Object)c);
            QName port = info.getQName();
            String name = info.getServiceName();
            this.message("");
            this.message("Checking for " + name + " service ...");
            try {
                List list = this.registry.listServices(port);
                int n = list.size();
                if (n == 0) {
                    this.message("... no services available");
                    continue;
                }
                this.message("... OK, found " + n + " service(s)");
                if (!this.details) continue;
                for (EndpointReferenceType e : list) {
                    this.message(" * " + e.getAddress().getStringValue());
                    String infoS = info.getServiceDetails(e, this.securityProperties);
                    if (infoS == null) continue;
                    this.message("   " + infoS);
                }
            }
            catch (Exception e) {
                this.error("... FAILED.", e);
            }
        }
    }
}

