/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.actions;

import de.fzj.unicore.ucc.UCCOptions;
import de.fzj.unicore.ucc.actions.ActionBase;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.commons.cli.OptionBuilder;
import org.apache.xmlbeans.XmlOptions;

public class SaveAttributeAssertion
extends ActionBase {
    @Override
    public String getName() {
        return "save-attributes";
    }

    @Override
    public String getDescription() {
        return "save attribute assertion to XML file.";
    }

    @Override
    public String getCommandGroup() {
        return "Security";
    }

    @Override
    public String getSynopsis() {
        return "Save attribute assertion to XML file. If given VO URL with the option -J, it connects to it and fetches an assertion. If given a file with an assertion with the option -A, it loads the assertion from the file. The attributes are filtered. If the option -O <file> is specified, then the assertion is written to the file.";
    }

    @Override
    protected void createOptions() {
        super.createOptions();
        UCCOptions uCCOptions = this.getOptions();
        OptionBuilder.withLongOpt((String)"attributeListOutFile");
        OptionBuilder.withDescription((String)"File to save assertion; empty for stdout");
        OptionBuilder.withArgName((String)"OutputFile");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        uCCOptions.addOption(OptionBuilder.create((String)"O"));
        UCCOptions uCCOptions2 = this.getOptions();
        OptionBuilder.withLongOpt((String)"prettifyAssertion");
        OptionBuilder.withDescription((String)"Reformat the assertion before being outputted so it is human readable. WARNING: such reformatted assertion WILL NOT be useful for authorization.");
        OptionBuilder.isRequired((boolean)false);
        uCCOptions2.addOption(OptionBuilder.create((String)"P"));
    }

    @Override
    protected boolean skipConnectingToRegistry() {
        return null != this.getOption("attributeAssertion", "A") || !"auto".equals(this.getOption("VO", "J"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() {
        super.process();
        if (!this.useSAMLPush) {
            this.message("No assertion specified. Specify a VO server or a file containing an assertion.");
            this.endProcessing(1);
        }
        if (null == this.getOption("attributeAssertion", "A") && null == this.getOption("VO", "J")) {
            this.message("Neither VO server URL nor attribute assertion file to parse was provided");
            this.endProcessing(1);
        }
        String outputFilename = this.getOption("attributeListOutFile", "O");
        Writer outputWriter = null;
        if (outputFilename != null && !outputFilename.isEmpty()) {
            File file = new File(outputFilename);
            try {
                outputWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charset.forName("UTF-8")));
                this.writeAssertion(outputWriter);
                String assertionSource = "";
                assertionSource = this.voURL == null || this.voURL.isEmpty() ? this.getOption("attributeAssertion", "A") : this.voURL;
                this.message("Attribute assertion from " + assertionSource + " successfully saved in " + outputFilename);
            }
            catch (IOException e) {
                this.error("Error writing to file: " + outputFilename, e);
                this.endProcessing(1);
            }
            finally {
                if (outputWriter != null) {
                    try {
                        outputWriter.close();
                    }
                    catch (Exception ex) {}
                }
            }
        } else {
            outputWriter = new OutputStreamWriter(System.out);
            try {
                this.writeAssertion(outputWriter);
                outputWriter.write("\n");
                outputWriter.flush();
            }
            catch (IOException ex) {
                throw new RuntimeException("Failed to write assertion onto the standard output.", ex);
            }
        }
    }

    private void writeAssertion(Writer writer) throws IOException {
        boolean prettify = this.getBooleanOption("prettifyAssertion", "P");
        XmlOptions saveOpts = new XmlOptions();
        if (prettify) {
            saveOpts.setSavePrettyPrint();
        }
        this.rawSAMLAssertion.getXML().save(writer, saveOpts);
        writer.flush();
    }
}

