/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.actions;

import de.fzj.unicore.ucc.UCCOptions;
import de.fzj.unicore.ucc.actions.ActionBase;
import de.fzj.unicore.ucc.helpers.EndProcessingException;
import de.fzj.unicore.ucc.runner.Runner;
import de.fzj.unicore.ucc.util.Builder;
import de.fzj.unicore.ucc.util.UnitParser;
import java.io.ByteArrayOutputStream;
import java.io.File;
import org.apache.commons.cli.OptionBuilder;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionDocument;

public class Run
extends ActionBase {
    protected Runner runner;
    protected Builder builder;
    protected String siteName = null;
    protected boolean synchronous;
    protected boolean brief;
    protected boolean isJSDL;
    protected boolean validateJSDL = true;
    protected String scheduled = null;
    private static String lastJobAddress;
    private static String lastJobFile;
    private static String lastJobPropertiesFile;

    @Override
    protected void createOptions() {
        super.createOptions();
        UCCOptions uCCOptions = this.getOptions();
        OptionBuilder.withLongOpt((String)"asynchronous");
        OptionBuilder.withDescription((String)"Run asynchronous, writing a job ID file for use with other ucc commands");
        OptionBuilder.isRequired((boolean)false);
        uCCOptions.addOption(OptionBuilder.create((String)"a"));
        UCCOptions uCCOptions2 = this.getOptions();
        OptionBuilder.withLongOpt((String)"sitename");
        OptionBuilder.withDescription((String)"Site Name");
        OptionBuilder.withArgName((String)"Vsite");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        uCCOptions2.addOption(OptionBuilder.create((String)"s"));
        UCCOptions uCCOptions3 = this.getOptions();
        OptionBuilder.withLongOpt((String)"brief");
        OptionBuilder.withDescription((String)"Short output file names");
        OptionBuilder.isRequired((boolean)false);
        uCCOptions3.addOption(OptionBuilder.create((String)"b"));
        UCCOptions uCCOptions4 = this.getOptions();
        OptionBuilder.withLongOpt((String)"stdout");
        OptionBuilder.withDescription((String)"Name name for storing the standard output");
        OptionBuilder.withArgName((String)"stdout");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        uCCOptions4.addOption(OptionBuilder.create((String)"O"));
        UCCOptions uCCOptions5 = this.getOptions();
        OptionBuilder.withLongOpt((String)"stderr");
        OptionBuilder.withDescription((String)"Name name for storing the standard error");
        OptionBuilder.withArgName((String)"stderr");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        uCCOptions5.addOption(OptionBuilder.create((String)"E"));
        UCCOptions uCCOptions6 = this.getOptions();
        OptionBuilder.withLongOpt((String)"jsdl");
        OptionBuilder.withDescription((String)"Treat job file as JSDL document");
        OptionBuilder.isRequired((boolean)false);
        uCCOptions6.addOption(OptionBuilder.create((String)"j"));
        UCCOptions uCCOptions7 = this.getOptions();
        OptionBuilder.withLongOpt((String)"example");
        OptionBuilder.withDescription((String)"Print an example job and quit");
        OptionBuilder.isRequired((boolean)false);
        uCCOptions7.addOption(OptionBuilder.create((String)"H"));
        UCCOptions uCCOptions8 = this.getOptions();
        OptionBuilder.withLongOpt((String)"schedule");
        OptionBuilder.withDescription((String)"Schedule the job for a specific time (in ISO8601 format)");
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.hasArg();
        uCCOptions8.addOption(OptionBuilder.create((String)"S"));
    }

    @Override
    public String getName() {
        return "run";
    }

    @Override
    public String getArgumentList() {
        return "[<jobfile>]";
    }

    @Override
    public String getSynopsis() {
        return "Runs a job through UNICORE 6. The job definition is read from <jobfile> or stdin. Run 'ucc run -H' to see an example job.A job can be executed in two modes. In the default synchronous mode, UCC will wait for the job to finish. In asynchonous mode, initiated by the 'a' option, a descriptor file will be written that can be used later with other UCC commands.";
    }

    @Override
    public String getDescription() {
        return "run a job through UNICORE 6";
    }

    @Override
    public String getCommandGroup() {
        return "Job execution";
    }

    @Override
    public void process() {
        super.process();
        if (this.getBooleanOption("example", "H")) {
            this.printSampleJob();
            this.endProcessing(0);
        }
        this.siteName = this.getCommandLine().getOptionValue("s");
        this.synchronous = !this.getBooleanOption("asynchronous", "a");
        this.verbose("Synchronous processing = " + this.synchronous);
        this.brief = this.getBooleanOption("brief", "b");
        this.verbose("Adding job id to output file names = " + !this.brief);
        this.isJSDL = this.getBooleanOption("jsdl", "j");
        this.verbose("Assuming JSDL job file = " + this.isJSDL);
        this.scheduled = this.getOption("schedule", "S");
        if (this.scheduled != null) {
            this.scheduled = UnitParser.convertDateToISO8601(this.scheduled);
            this.verbose("Will schedule job submission for " + this.scheduled);
        }
        if (this.getCommandLine().getArgs().length > 1) {
            for (int i = 1; i < this.getCommandLine().getArgs().length; ++i) {
                this.initBuilder(this.getCommandLine().getArgs()[i]);
                this.run();
            }
        } else {
            this.initBuilderFromStdin();
            this.run();
        }
    }

    protected void initBuilder(String jobFile) {
        if (this.isJSDL) {
            try {
                this.verbose("Loading JSDL file.");
                this.builder = new Builder();
                this.builder.setMessageWriter(this);
                this.builder.setRegistry(this.registry);
                this.builder.setSecurityProperties(this.securityProperties);
                JobDefinitionDocument jdd = JobDefinitionDocument.Factory.parse((File)new File(jobFile));
                if (this.validateJSDL) {
                    this.doValidate(jdd);
                }
                this.builder.setJob(jdd);
            }
            catch (Exception e) {
                this.error("Can't parse jsdl file <" + jobFile + ">", e);
                this.endProcessing(2);
            }
        } else {
            try {
                this.builder = new Builder(new File(jobFile));
                this.builder.setMessageWriter(this);
                this.builder.setRegistry(this.registry);
                this.builder.setSecurityProperties(this.securityProperties);
                this.verbose("Read job from <" + jobFile + ">");
            }
            catch (Exception e) {
                this.error("Can't parse job file <" + jobFile + ">", e);
                this.endProcessing(2);
            }
        }
    }

    protected void initBuilderFromStdin() {
        try {
            this.message("Reading job from stdin:");
            this.message("");
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int b = 0;
            while ((b = System.in.read()) != -1) {
                bos.write(b);
            }
            this.builder = new Builder(bos.toString());
        }
        catch (Exception e) {
            this.error("Can't read job from stdin.", e);
            this.endProcessing(2);
        }
    }

    protected void run() {
        this.builder.setProperty("Output", this.output.getAbsolutePath());
        this.builder.setProperty("IDLocation", this.output.getAbsolutePath());
        this.builder.setProperty("KeepFinishedJob", "true");
        this.builder.setProperty("DetailedStatusDisplay", "true");
        if (this.scheduled != null) {
            this.builder.setProperty("Not before", this.scheduled);
        }
        if (this.siteName != null) {
            this.builder.setProperty("Site", this.siteName);
        }
        this.runner = new Runner(this.registry, this.securityProperties, this.builder, this);
        this.runner.setAsyncMode(!this.synchronous);
        this.runner.setBriefOutfileNames(this.brief);
        this.runner.setProperties(this.properties);
        try {
            this.runner.run();
            lastJobPropertiesFile = this.runner.dumpJobProperties();
            lastJobAddress = this.runner.getJob().getEPR().getAddress().getStringValue();
            lastJobFile = this.builder.getProperty("jobIdFile");
        }
        catch (RuntimeException ex) {
            this.runner.dumpJobLog();
            this.endProcessing(1);
        }
    }

    protected void doValidate(JobDefinitionDocument jdd) {
        boolean isValid = Builder.isValidJSDL(jdd, this);
        if (!isValid && Boolean.parseBoolean(this.properties.getProperty("ucc.validation.fail_on_errors"))) {
            String message = "Stopping due to validation errors (set property 'ucc.validation.fail_on_errors=false' to ignore them)";
            throw new EndProcessingException(5, message);
        }
    }

    public void printSampleJob() {
        this.message(Builder.getJobSample());
    }

    public static String getLastJobAddress() {
        return lastJobAddress;
    }

    public static String getLastJobFile() {
        return lastJobFile;
    }

    public static String getLastJobPropertiesFile() {
        return lastJobPropertiesFile;
    }
}

