/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.actions;

import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.ucc.MessageWriter;
import de.fzj.unicore.ucc.UCCOptions;
import de.fzj.unicore.ucc.actions.ActionBase;
import de.fzj.unicore.ucc.helpers.IResolve;
import de.fzj.unicore.ucc.helpers.Location;
import de.fzj.unicore.wsrflite.xmlbeans.client.IRegistryQuery;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.cli.OptionBuilder;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class Resolve
extends ActionBase {
    protected Location targetDesc;
    protected boolean full;
    private static Map<String, IResolve> resolvers = new HashMap<String, IResolve>();

    public static void addResolver(String uriScheme, IResolve resolver) {
        resolvers.put(uriScheme, resolver);
    }

    @Override
    protected void createOptions() {
        super.createOptions();
        UCCOptions uCCOptions = this.getOptions();
        OptionBuilder.withLongOpt((String)"full");
        OptionBuilder.withDescription((String)"Print full file URI");
        OptionBuilder.isRequired((boolean)false);
        uCCOptions.addOption(OptionBuilder.create((String)"f"));
    }

    public static Location resolve(String uri, IRegistryQuery registry, IClientConfiguration security, MessageWriter messageWriter) {
        IResolve r;
        Location loc = null;
        Iterator<IResolve> i$ = resolvers.values().iterator();
        while (i$.hasNext() && (loc = (r = i$.next()).resolve(uri, registry, security, messageWriter)) == null) {
        }
        if (loc == null) {
            loc = new Location(uri, registry, security, messageWriter);
        }
        return loc;
    }

    @Override
    public void process() {
        super.process();
        String target = this.getCommandLine().getArgs()[1];
        this.targetDesc = Resolve.resolve(target, this.registry, this.securityProperties, this);
        this.full = this.getBooleanOption("full", "f");
        EndpointReferenceType e = EndpointReferenceType.Factory.newInstance();
        e.addNewAddress().setStringValue(this.targetDesc.getSmsEpr());
        try {
            StorageClient sms = new StorageClient(this.targetDesc.getSmsEpr(), e, this.securityProperties);
            this.verbose("SMS " + this.targetDesc.getSmsEpr() + " contacted, server reply: servertime=" + sms.getCurrentTime());
        }
        catch (Exception ex) {
            this.error("Can't contact storage service.", ex);
            this.endProcessing(1);
        }
        String result = this.full ? this.targetDesc.getUnicore6URI() : e.getAddress().getStringValue();
        this.message(result);
    }

    @Override
    public String getName() {
        return "resolve";
    }

    @Override
    public String getSynopsis() {
        return "Resolves a remote location given in the form 'unicore6://SITE/location/file_path',and prints the storage URL. Use the '-f' option to print the full UNICORE file URI of the form PROTOCOL:StorageURL#/file_path";
    }

    @Override
    public String getDescription() {
        return "resolve remote location";
    }

    @Override
    public String getArgumentList() {
        return "[unicore6://SITENAME/[JobId|StorageName]]";
    }

    @Override
    public String getCommandGroup() {
        return "Data management";
    }
}

