/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.actions;

import de.fzj.unicore.uas.client.ReservationClient;
import de.fzj.unicore.uas.client.TSSClient;
import de.fzj.unicore.ucc.UCCOptions;
import de.fzj.unicore.ucc.actions.ActionBase;
import de.fzj.unicore.ucc.helpers.TargetSystemLister;
import de.fzj.unicore.ucc.runner.RandomSelection;
import de.fzj.unicore.ucc.runner.Requirement;
import de.fzj.unicore.ucc.runner.RunnerException;
import de.fzj.unicore.ucc.runner.TargetSystemFinder;
import de.fzj.unicore.ucc.util.Builder;
import de.fzj.unicore.ucc.util.UnitParser;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.cli.OptionBuilder;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ResourcesDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ResourcesType;
import org.unigrids.x2006.x04.services.reservation.ReservationPropertiesDocument;
import org.unigrids.x2006.x04.services.tss.TargetSystemPropertiesDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class Reservation
extends ActionBase {
    protected String siteName = null;
    protected boolean isJSDL = false;
    protected Calendar requestedStart = null;
    public static final String OPT_STARTTIME_LONG = "start";
    public static final String OPT_STARTTIME = "S";
    public static final String OPT_LIST_LONG = "list";
    public static final String OPT_LIST = "l";
    public static final String OPT_DELETE_LONG = "delete";
    public static final String OPT_DELETE = "d";
    static String lastReservationID = null;
    static String lastReservationURL = null;
    static Integer lastNumberOfReservations = null;

    @Override
    protected void createOptions() {
        super.createOptions();
        UCCOptions uCCOptions = this.getOptions();
        OptionBuilder.withLongOpt((String)"sitename");
        OptionBuilder.withDescription((String)"Site Name");
        OptionBuilder.withArgName((String)"Vsite");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        uCCOptions.addOption(OptionBuilder.create((String)"s"));
        UCCOptions uCCOptions2 = this.getOptions();
        OptionBuilder.withLongOpt((String)"jsdl");
        OptionBuilder.withDescription((String)"Treat resources file as JSDL document");
        OptionBuilder.isRequired((boolean)false);
        uCCOptions2.addOption(OptionBuilder.create((String)"j"));
        UCCOptions uCCOptions3 = this.getOptions();
        OptionBuilder.withLongOpt((String)OPT_LIST_LONG);
        OptionBuilder.withDescription((String)"List your reservations.");
        OptionBuilder.isRequired((boolean)false);
        uCCOptions3.addOption(OptionBuilder.create((String)OPT_LIST));
        UCCOptions uCCOptions4 = this.getOptions();
        OptionBuilder.withLongOpt((String)OPT_DELETE_LONG);
        OptionBuilder.withDescription((String)"Delete a reservation.");
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"ReservationReference");
        uCCOptions4.addOption(OptionBuilder.create((String)OPT_DELETE));
        UCCOptions uCCOptions5 = this.getOptions();
        OptionBuilder.withLongOpt((String)OPT_STARTTIME_LONG);
        OptionBuilder.withDescription((String)"Requested start time for the reservation");
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withArgName((String)"Starttime");
        OptionBuilder.hasArg();
        uCCOptions5.addOption(OptionBuilder.create((String)OPT_STARTTIME));
    }

    @Override
    public void process() {
        super.process();
        this.siteName = this.getCommandLine().getOptionValue("s");
        if (this.getBooleanOption(OPT_LIST_LONG, OPT_LIST)) {
            try {
                this.doList();
                return;
            }
            catch (Exception e) {
                this.error("Can't list reservations.", e);
                this.endProcessing(1);
            }
        }
        if (this.getBooleanOption(OPT_DELETE_LONG, OPT_DELETE)) {
            try {
                this.doDelete();
                return;
            }
            catch (Exception e) {
                this.error("Can't delete reservation.", e);
                this.endProcessing(1);
            }
        }
        this.isJSDL = this.getBooleanOption("jsdl", "j");
        this.verbose("Assuming JSDL resources file = " + this.isJSDL);
        String requestedStartTime = this.getOption("schedule", OPT_STARTTIME);
        if (requestedStartTime != null) {
            Date req = UnitParser.extractDateTime(requestedStartTime);
            this.requestedStart = Calendar.getInstance();
            this.requestedStart.setTime(req);
            this.verbose("Requested start time " + this.requestedStart.getTime());
        } else {
            this.error("Please provide a start time!", null);
            this.endProcessing(1);
        }
        try {
            this.doCreate();
        }
        catch (Exception e) {
            this.error("Can't create reservation.", e);
            this.endProcessing(1);
        }
    }

    @Override
    public String getName() {
        return "reservation";
    }

    @Override
    public String getArgumentList() {
        return "command <options>";
    }

    @Override
    public String getSynopsis() {
        return "Create and manage your reservations. You can make a reservation at a site specified using the 'sitename' option. The resources to reserve are specified using a UCC job file. The requested start time is given using the 'start' option. The supported date formats are 'HH:mm', 'yyyy-MM-dd HH:mm' and ISO8601. To list your reservations, use the 'list' option. Use the 'delete' option to delete a reservation, specifying the reservation reference on the command line.";
    }

    @Override
    public String getDescription() {
        return "create and manage reservations";
    }

    @Override
    public String getCommandGroup() {
        return "Job execution";
    }

    protected TSSClient findTSS(Builder builder) throws RunnerException {
        TargetSystemFinder finder = new TargetSystemFinder(this.registry, this.securityProperties, new RandomSelection(), this.siteName, this);
        finder.setCheckResources(true);
        builder.getRequirements().add(new ReservationRequirement());
        return finder.find(builder.getRequirements());
    }

    protected void doCreate() throws Exception {
        Builder builder = this.initBuilder();
        TSSClient tss = this.findTSS(builder);
        ResourcesType res = builder.getJob().getJobDefinition().getJobDescription().getResources();
        ResourcesDocument resources = ResourcesDocument.Factory.newInstance();
        resources.setResources(res);
        ReservationClient rrClient = tss.createReservationClient(resources, this.requestedStart);
        this.showReservationDetails(rrClient);
    }

    protected void doList() throws Exception {
        TargetSystemLister tsl = new TargetSystemLister(this.registry, this.securityProperties, this);
        lastNumberOfReservations = 0;
        if (this.siteName != null) {
            TSSClient tss = tsl.getTSS(this.siteName);
            if (tss != null) {
                this.verbose("Listing reservations on site '" + this.siteName + "'");
                this.listReservationsOnTSS(tss);
            } else {
                this.message("Target system at site '" + this.siteName + "' does not exist! Check the site name or try 'ucc connect' first.");
            }
        } else {
            for (TSSClient tss : tsl) {
                this.listReservationsOnTSS(tss);
            }
        }
    }

    protected void listReservationsOnTSS(TSSClient tss) throws Exception {
        if (!tss.supportsReservation()) {
            this.message("TSS " + tss.getTargetSystemName() + " does not support reservations.");
            return;
        }
        this.message("Site: " + tss.getTargetSystemName());
        this.message(tss.getUrl());
        for (EndpointReferenceType epr : tss.getReservations()) {
            this.showReservationDetails(new ReservationClient(epr, tss.getSecurityConfiguration()));
            Integer n = lastNumberOfReservations;
            Integer n2 = lastNumberOfReservations = Integer.valueOf(lastNumberOfReservations + 1);
        }
    }

    protected void showReservationDetails(ReservationClient r) throws Exception {
        ReservationPropertiesDocument.ReservationProperties rp = r.getResourcePropertiesDocument().getReservationProperties();
        this.message(" Reservation: " + rp.getReservationReference());
        this.message("   URL      : " + r.getUrl());
        Calendar start = rp.getStartTime();
        this.message("   Starting : " + (start != null ? start : "n/a"));
        this.message("   Status   : " + rp.getReservationStatus());
        String desc = rp.getReservationStatusDescription();
        this.message("   Descript.: " + (desc != null ? desc : "n/a"));
        lastReservationID = rp.getReservationReference();
        lastReservationURL = r.getUrl();
    }

    protected void doDelete() throws Exception {
        String resID = null;
        resID = this.getOption(OPT_DELETE_LONG, OPT_DELETE);
        if (resID == null) {
            throw new IllegalArgumentException("Please specify a reservation ID to delete!");
        }
        TargetSystemLister tsl = new TargetSystemLister(this.registry, this.securityProperties, this);
        if (this.siteName != null) {
            TSSClient tss = tsl.getTSS(this.siteName);
            if (tss != null) {
                this.findAndDelete(resID, tss);
            } else {
                this.message("Target system at site '" + this.siteName + "' does not exist! Check the site name or try 'ucc connect' first.");
            }
        } else {
            for (TSSClient tss : tsl) {
                this.findAndDelete(resID, tss);
            }
        }
    }

    protected boolean findAndDelete(String resID, TSSClient tss) throws Exception {
        boolean found = false;
        if (!tss.supportsReservation()) {
            this.verbose("TSS " + tss.getTargetSystemName() + " does not support reservations.");
        } else {
            for (EndpointReferenceType epr : tss.getReservations()) {
                ReservationClient r = new ReservationClient(epr, tss.getSecurityConfiguration());
                if (!resID.equals(r.getReservationReference())) continue;
                r.destroy();
                this.message("Deleting reservation " + resID);
                found = true;
                break;
            }
        }
        return found;
    }

    protected Builder initBuilder() {
        String jobFile = null;
        Builder builder = null;
        if (this.getCommandLine().getArgs().length > 1) {
            jobFile = this.getCommandLine().getArgs()[1];
            if (this.isJSDL) {
                try {
                    this.verbose("Loading JSDL file.");
                    builder = new Builder();
                    builder.setMessageWriter(this);
                    builder.setRegistry(this.registry);
                    builder.setSecurityProperties(this.securityProperties);
                    JobDefinitionDocument jdd = JobDefinitionDocument.Factory.parse((File)new File(jobFile));
                    builder.setJob(jdd);
                }
                catch (Exception e) {
                    this.error("Can't parse jsdl file <" + jobFile + ">", e);
                    this.endProcessing(2);
                }
            } else {
                try {
                    builder = new Builder(new File(jobFile));
                    builder.setMessageWriter(this);
                    builder.setRegistry(this.registry);
                    builder.setSecurityProperties(this.securityProperties);
                    this.verbose("Read job from <" + jobFile + ">");
                }
                catch (Exception e) {
                    this.error("Can't parse job file <" + jobFile + ">", e);
                    this.endProcessing(2);
                }
            }
        } else {
            try {
                this.message("Reading job from stdin:");
                this.message("");
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                int b = 0;
                while ((b = System.in.read()) != -1) {
                    bos.write(b);
                }
                builder = new Builder(bos.toString());
            }
            catch (Exception e) {
                this.error("Can't read job from stdin.", e);
                this.endProcessing(2);
            }
        }
        return builder;
    }

    public static class ReservationRequirement
    implements Requirement {
        @Override
        public boolean isFulfilled(TargetSystemPropertiesDocument.TargetSystemProperties tss) {
            return tss.getSupportsReservation();
        }

        @Override
        public String getDescription() {
            return "Resource reservation support";
        }

        public int hashCode() {
            return 1;
        }

        public boolean equals(Object obj) {
            return obj != null && obj instanceof ReservationRequirement;
        }
    }
}

