/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.actions;

import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.ucc.UCCOptions;
import de.fzj.unicore.ucc.actions.SMSOperation;
import de.fzj.unicore.ucc.helpers.Location;
import java.io.IOException;
import jline.ConsoleReader;
import org.apache.commons.cli.OptionBuilder;

public class RM
extends SMSOperation {
    protected Location targetDesc;

    @Override
    protected void createOptions() {
        super.createOptions();
        UCCOptions uCCOptions = this.getOptions();
        OptionBuilder.withLongOpt((String)"quiet");
        OptionBuilder.withDescription((String)"quiet mode");
        OptionBuilder.isRequired((boolean)false);
        uCCOptions.addOption(OptionBuilder.create((String)"q"));
    }

    @Override
    public void process() {
        super.process();
        boolean quiet = this.getBooleanOption("quiet", "q");
        String target = this.getCommandLine().getArgs()[1];
        StorageClient sms = this.getStorageClient(target);
        try {
            boolean confirmed;
            String dir = this.getPathAtStorage(target);
            if (!quiet && !(confirmed = this.confirm())) {
                this.verbose("Cancelled.");
                return;
            }
            sms.delete(dir);
        }
        catch (Exception ex) {
            this.error("Can't contact storage service.", ex);
            this.endProcessing(1);
        }
    }

    protected boolean confirm() {
        try {
            String line = new ConsoleReader().readLine("This will delete a remote file/directory, are you sure? [Y]");
            return line.length() == 0 || line.startsWith("y") || line.startsWith("Y");
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public String getName() {
        return "rm";
    }

    @Override
    public String getSynopsis() {
        return "remove a file or directory on a remote storage.";
    }

    @Override
    public String getDescription() {
        return "remove a remote file or directory";
    }

    @Override
    public String getArgumentList() {
        return "[unicore6://SITENAME/[JobId|StorageName]]";
    }

    @Override
    public String getCommandGroup() {
        return "Data management";
    }
}

