/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.actions;

import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.ucc.UCCOptions;
import de.fzj.unicore.ucc.actions.FileOperation;
import de.fzj.unicore.ucc.helpers.Location;
import de.fzj.unicore.ucc.util.FileUploader;
import de.fzj.unicore.ucc.util.Mode;
import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import org.apache.commons.cli.OptionBuilder;
import org.unigrids.services.atomic.types.ProtocolType;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class PutFile
extends FileOperation {
    protected Location targetDesc;
    protected StorageClient sms;
    protected boolean recurse;
    protected boolean append;

    @Override
    protected void createOptions() {
        super.createOptions();
        UCCOptions uCCOptions = this.getOptions();
        OptionBuilder.withLongOpt((String)"append");
        OptionBuilder.withDescription((String)"Append to (existing) file");
        OptionBuilder.isRequired((boolean)false);
        uCCOptions.addOption(OptionBuilder.create((String)"a"));
        UCCOptions uCCOptions2 = this.getOptions();
        OptionBuilder.withLongOpt((String)"recursive");
        OptionBuilder.withDescription((String)"Recurse into subdirectories");
        OptionBuilder.isRequired((boolean)false);
        uCCOptions2.addOption(OptionBuilder.create((String)"R"));
    }

    @Override
    public void process() {
        super.process();
        this.targetDesc = new Location(this.target, this.registry, this.securityProperties, this);
        this.verbose("Target URL " + this.targetDesc.getUnicore6URI());
        this.append = this.getBooleanOption("append", "a");
        this.verbose("Appending data=" + this.append);
        this.recurse = this.getBooleanOption("recursive", "R");
        if (this.recurse) {
            this.verbose("Recurse into subdirectories=" + this.recurse);
        }
        try {
            EndpointReferenceType e = EndpointReferenceType.Factory.newInstance();
            e.addNewAddress().setStringValue(this.targetDesc.getSmsEpr());
            String dn = this.findServerName(e);
            if (dn != null) {
                WSUtilities.addServerIdentity((EndpointReferenceType)e, (String)dn);
            }
            this.sms = new StorageClient(this.targetDesc.getSmsEpr(), e, this.securityProperties);
            this.verbose("SMS contacted, server reply: servertime=" + this.sms.getCurrentTime());
            this.putFile();
        }
        catch (Exception e) {
            this.error("Can't put file.", e);
            this.endProcessing(1);
        }
    }

    protected void putFile() throws Exception {
        Mode mode = this.append ? Mode.append : Mode.overwrite;
        FileUploader imp = new FileUploader(this.source, this.targetDesc.getName(), mode);
        String targetDescProtocol = this.targetDesc.getProtocol();
        if (!"BFT".equalsIgnoreCase(targetDescProtocol)) {
            try {
                this.preferredProtocols.add(0, ProtocolType.Enum.forString((String)targetDescProtocol));
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        imp.setPreferredProtocols(this.preferredProtocols);
        imp.setExtraParameterSource(this.properties);
        imp.setTiming(this.timing);
        imp.setRecurse(this.recurse);
        if (this.startByte != null) {
            imp.setStartByte(this.startByte);
            imp.setEndByte(this.endByte);
        }
        imp.perform(this.sms, this);
    }

    @Override
    public String getName() {
        return "put-file";
    }

    @Override
    public String getSynopsis() {
        return "Writes a local file specified by the '-s' option to a remote location '-t'.";
    }

    @Override
    public String getDescription() {
        return "put a local file to a remote server";
    }

    @Override
    public String getArgumentList() {
        return "";
    }

    @Override
    public String getCommandGroup() {
        return "Data management";
    }
}

