/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.actions;

import de.fzj.unicore.uas.client.MetadataClient;
import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.uas.client.TaskClient;
import de.fzj.unicore.ucc.UCCOptions;
import de.fzj.unicore.ucc.actions.ActionBase;
import de.fzj.unicore.ucc.helpers.EndProcessingException;
import de.fzj.unicore.ucc.helpers.Location;
import de.fzj.unicore.ucc.util.JSONUtil;
import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.io.FileUtils;
import org.json.JSONObject;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class Metadata
extends ActionBase {
    public static String OPT_COMMAND_LONG = "command";
    public static String OPT_COMMAND = "C";
    public static String OPT_STORAGE_LONG = "storage";
    public static String OPT_STORAGE = "s";
    public static String OPT_META_LONG = "metadata-service";
    public static String OPT_META = "m";
    public static String OPT_FILE_LONG = "file";
    public static String OPT_FILE = "f";
    public static String OPT_QUERY_LONG = "query";
    public static String OPT_QUERY = "q";
    public static String OPT_QUERYADV_LONG = "advanced-query";
    public static String OPT_QUERYADV = "a";
    protected String metaURL;
    protected MetadataClient meta;
    protected String command;
    protected String path;
    protected File file;
    protected String query;
    boolean advanced;
    private static Map<String, String> lastMeta;

    @Override
    public String getName() {
        return "metadata";
    }

    @Override
    protected void createOptions() {
        super.createOptions();
        UCCOptions uCCOptions = this.getOptions();
        OptionBuilder.withLongOpt((String)OPT_COMMAND_LONG);
        OptionBuilder.withDescription((String)"Metadata command: create, read, update, delete, start-extract, search");
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.hasArg();
        uCCOptions.addOption(OptionBuilder.create((String)OPT_COMMAND));
        UCCOptions uCCOptions2 = this.getOptions();
        OptionBuilder.withLongOpt((String)OPT_STORAGE_LONG);
        OptionBuilder.withDescription((String)"Storage address");
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withArgName((String)"Storage");
        OptionBuilder.hasArg();
        uCCOptions2.addOption(OptionBuilder.create((String)OPT_STORAGE));
        UCCOptions uCCOptions3 = this.getOptions();
        OptionBuilder.withLongOpt((String)OPT_META_LONG);
        OptionBuilder.withDescription((String)"Metadata service address");
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withArgName((String)"MetadataService");
        OptionBuilder.hasArg();
        uCCOptions3.addOption(OptionBuilder.create((String)OPT_META));
        UCCOptions uCCOptions4 = this.getOptions();
        OptionBuilder.withLongOpt((String)OPT_FILE_LONG);
        OptionBuilder.withDescription((String)"File containing metadata");
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withArgName((String)"Filename");
        OptionBuilder.hasArg();
        uCCOptions4.addOption(OptionBuilder.create((String)OPT_FILE));
        UCCOptions uCCOptions5 = this.getOptions();
        OptionBuilder.withLongOpt((String)OPT_QUERY_LONG);
        OptionBuilder.withDescription((String)"Query string for search");
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withArgName((String)"Query");
        OptionBuilder.hasArg();
        uCCOptions5.addOption(OptionBuilder.create((String)OPT_QUERY));
        UCCOptions uCCOptions6 = this.getOptions();
        OptionBuilder.withLongOpt((String)OPT_QUERYADV_LONG);
        OptionBuilder.withDescription((String)"Advanced query");
        OptionBuilder.isRequired((boolean)false);
        uCCOptions6.addOption(OptionBuilder.create((String)OPT_QUERYADV));
    }

    @Override
    public void process() {
        super.process();
        this.command = this.getOption(OPT_COMMAND_LONG, OPT_COMMAND);
        this.verbose("Operation = " + this.command);
        this.metaURL = this.getOption(OPT_META_LONG, OPT_META);
        if (this.metaURL != null) {
            EndpointReferenceType epr = EndpointReferenceType.Factory.newInstance();
            epr.addNewAddress().setStringValue(this.metaURL);
            try {
                String dn = this.findServerName(epr);
                if (dn != null) {
                    WSUtilities.addServerIdentity((EndpointReferenceType)epr, (String)dn);
                }
                this.meta = new MetadataClient(epr, this.securityProperties);
            }
            catch (Exception ex) {
                this.error("Can't create metadata client for " + this.metaURL, ex);
                this.endProcessing(2);
            }
        } else {
            String storage = this.getOption(OPT_STORAGE_LONG, OPT_STORAGE);
            if (storage == null) {
                String desc = this.getArgument(1);
                Location loc = new Location(desc, this.registry, this.securityProperties, this);
                storage = loc.getSmsEpr();
                this.path = loc.getName();
            }
            this.findMetadataService(storage);
        }
        if (this.metaURL == null) {
            this.message("Cannot find a metadata service to use!");
            this.printUsage();
            this.endProcessing(2);
        }
        this.verbose("Using metadata service at " + this.metaURL);
        String fName = this.getOption(OPT_FILE_LONG, OPT_FILE);
        if (fName != null) {
            this.file = new File(fName);
        }
        if ("read".startsWith(this.command)) {
            if (this.path == null) {
                this.path = this.getArgument(1);
            }
            this.doGet();
        } else if ("create".startsWith(this.command)) {
            if (this.path == null) {
                this.path = this.getArgument(1);
            }
            this.doCreate();
        } else if ("update".startsWith(this.command)) {
            if (this.path == null) {
                this.path = this.getArgument(1);
            }
            this.doUpdate();
        } else if ("delete".startsWith(this.command)) {
            if (this.path == null) {
                this.path = this.getArgument(1);
            }
            this.doDelete();
        } else if ("start-extract".startsWith(this.command)) {
            this.path = this.getArgument(1);
            this.doStartExtract();
        } else if ("search".startsWith(this.command)) {
            this.query = this.getOption(OPT_QUERY_LONG, OPT_QUERY);
            if (this.query == null) {
                this.error("Please provide a query string!", null);
                this.endProcessing(1);
            }
            this.advanced = this.getBooleanOption(OPT_QUERYADV_LONG, OPT_QUERYADV);
            this.doSearch();
        } else {
            this.error("Unknown command : " + this.command, null);
            this.endProcessing(1);
        }
    }

    protected void doGet() {
        try {
            Map result = this.meta.getMetadata(this.path);
            String json = JSONUtil.asJSON(result).toString(2);
            this.message(json);
            if (this.file != null) {
                FileUtils.writeStringToFile((File)this.file, (String)json);
            }
            lastMeta = result;
        }
        catch (Exception ex) {
            this.error("Error getting metadata for <" + this.path + ">", ex);
            this.endProcessing(1);
        }
    }

    protected void doCreate() {
        try {
            Map<String, String> data = this.readData();
            this.meta.createMetadata(this.path, data);
            lastMeta = data;
        }
        catch (Exception ex) {
            this.error("Error creating metadata for <" + this.path + ">", ex);
            this.endProcessing(1);
        }
    }

    protected void doUpdate() {
        try {
            Map<String, String> data = this.readData();
            this.meta.updateMetadata(this.path, data);
            lastMeta = data;
        }
        catch (Exception ex) {
            this.error("Error updating metadata for <" + this.path + ">", ex);
            this.endProcessing(1);
        }
    }

    protected void doSearch() {
        try {
            Collection results = this.meta.search(this.query, this.advanced);
            for (String s : results) {
                this.message(s);
            }
        }
        catch (Exception ex) {
            this.error("Error searching metadata", ex);
            this.endProcessing(1);
        }
    }

    protected void doDelete() {
        try {
            this.meta.deleteMetadata(this.path);
        }
        catch (Exception ex) {
            this.error("Error deleting metadata for <" + this.path + ">", ex);
            this.endProcessing(1);
        }
    }

    protected void doStartExtract() {
        try {
            int depth = 10;
            TaskClient task = this.meta.startMetadataExtraction(this.path, depth);
            this.message("Extraction started, task address = " + task.getUrl());
        }
        catch (Exception ex) {
            this.error("Error starting metadata extraction for <" + this.path + ">", ex);
            this.endProcessing(1);
        }
    }

    protected Map<String, String> readData() throws Exception {
        String json = null;
        if (this.file != null) {
            this.verbose("Reading data from the file: " + this.file.getName());
            json = FileUtils.readFileToString((File)this.file);
        } else {
            this.verbose("Reading from stdIn (it does not work from within the shell)");
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            String str = "";
            StringBuilder buffer = new StringBuilder();
            do {
                System.out.print(">> ");
                str = in.readLine();
                if (str == null) continue;
                buffer.append(str);
            } while (str != null && !str.isEmpty());
            json = buffer.toString();
        }
        JSONObject j = new JSONObject(json);
        return JSONUtil.asMap(j);
    }

    protected void findMetadataService(String storage) {
        Location td = null;
        StorageClient sms = null;
        try {
            td = new Location(storage, this.registry, this.securityProperties, this);
            EndpointReferenceType epr = EndpointReferenceType.Factory.newInstance();
            epr.addNewAddress().setStringValue(td.getSmsEpr());
            sms = new StorageClient(td.getSmsEpr(), epr, this.securityProperties);
            sms.getCurrentTime();
            this.verbose("Have storage epr=" + td.getSmsEpr() + ", access OK.");
        }
        catch (Exception e) {
            this.error("Can't access :" + storage, e);
            this.endProcessing(1);
        }
        try {
            if (!sms.supportsMetadata()) {
                this.message("Storage does not support metadata.");
                this.endProcessing(1);
            }
            this.meta = sms.getMetadataClient();
            this.metaURL = this.meta.getUrl();
        }
        catch (EndProcessingException epe) {
            throw epe;
        }
        catch (Exception e) {
            this.error("Can't get metadata service for :" + storage, e);
            this.endProcessing(1);
        }
    }

    @Override
    public String getDescription() {
        return "perform operations on metadata";
    }

    @Override
    public String getSynopsis() {
        return "Performs operations on metadata. Either a storage or directly a metadata service can be given.";
    }

    @Override
    public String getArgumentList() {
        return "[resource-name]";
    }

    @Override
    public String getCommandGroup() {
        return "Data management";
    }

    private String getArgument(int argN) {
        try {
            return this.getCommandLine().getArgs()[argN];
        }
        catch (IndexOutOfBoundsException ex) {
            this.error("This method requires at least " + argN + " arguments", null);
            this.endProcessing();
            return null;
        }
    }

    public static Map<String, String> getLastMeta() {
        return lastMeta;
    }
}

