/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.actions;

import de.fzj.unicore.uas.client.EnumerationClient;
import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.uas.client.TSSClient;
import de.fzj.unicore.uas.client.TransferControllerClient;
import de.fzj.unicore.ucc.MessageWriter;
import de.fzj.unicore.ucc.actions.ListActionBase;
import de.fzj.unicore.ucc.helpers.StorageLister;
import de.fzj.unicore.ucc.helpers.TargetSystemLister;
import de.fzj.unicore.ucc.util.UnitParser;
import org.w3.x2005.x08.addressing.EndpointReferenceDocument;

public class ListTransfers
extends ListActionBase<TransferControllerClient> {
    protected UnitParser unitParser = UnitParser.getCapacitiesParser(0);

    @Override
    public String getName() {
        return "list-transfers";
    }

    @Override
    public void process() {
        super.process();
        for (TSSClient c : new TargetSystemLister(this.registry, this.securityProperties, this)) {
            for (StorageClient sms : new StorageLister(c, this.securityProperties, (MessageWriter)this)) {
                this.verbose("Storage : " + sms.getUrl());
                try {
                    this.listFiletransfers(sms);
                }
                catch (Exception ex) {
                    this.error("Error listing storage at " + sms.getEPR().getAddress().getStringValue(), ex);
                }
            }
        }
        for (StorageClient sms : new StorageLister(this.registry, this.securityProperties, (MessageWriter)this)) {
            this.verbose("Storage : " + sms.getUrl());
            try {
                this.listFiletransfers(sms);
            }
            catch (Exception ex) {
                this.error("Error listing storage at " + sms.getEPR().getAddress().getStringValue(), ex);
            }
        }
    }

    protected void listFiletransfers(StorageClient sms) throws Exception {
        EnumerationClient ftEnumeration = sms.getFiletransferEnumeration();
        if (ftEnumeration == null) {
            return;
        }
        for (EndpointReferenceDocument eprd : ftEnumeration) {
            TransferControllerClient ftc = new TransferControllerClient(eprd.getEndpointReference(), this.securityProperties);
            if (!this.filterMatch(ftc)) continue;
            this.listFiletransfer(ftc);
            ++lastNumberOfResults;
        }
    }

    protected void listFiletransfer(TransferControllerClient ftc) {
        try {
            this.message(ftc.getUrl() + this.getDetails(ftc));
        }
        catch (Exception ex) {
            this.error("Error listing filetransfer at " + ftc.getUrl(), ex);
        }
        this.printWSRFProperties(ftc);
    }

    @Override
    protected String getDetails(TransferControllerClient ftc) {
        if (!this.detailed) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        try {
            sb.append(" ");
            sb.append(ftc.getStatus());
            sb.append(" ");
            sb.append(this.unitParser.getHumanReadable(ftc.getTransferredBytes()));
            sb.append("/");
            sb.append(this.unitParser.getHumanReadable(ftc.getSize()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }

    @Override
    public String getDescription() {
        return "list the server-to-server transfers";
    }

    @Override
    public String getArgumentList() {
        return "";
    }

    @Override
    public String getCommandGroup() {
        return "General";
    }
}

