/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.actions;

import de.fzj.unicore.uas.StorageManagement;
import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.uas.client.TSSClient;
import de.fzj.unicore.ucc.IServiceInfoProvider;
import de.fzj.unicore.ucc.MessageWriter;
import de.fzj.unicore.ucc.actions.ListActionBase;
import de.fzj.unicore.ucc.helpers.StorageLister;
import de.fzj.unicore.ucc.helpers.TargetSystemLister;
import de.fzj.unicore.ucc.util.UnitParser;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.util.Arrays;
import javax.xml.namespace.QName;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.RangeValueType;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class ListStorages
extends ListActionBase<StorageClient>
implements IServiceInfoProvider {
    protected UnitParser unitParser = UnitParser.getCapacitiesParser(1);

    @Override
    public String getName() {
        return "list-storages";
    }

    @Override
    protected void createOptions() {
        super.createOptions();
    }

    @Override
    public void process() {
        super.process();
        for (TSSClient c : new TargetSystemLister(this.registry, this.securityProperties, this)) {
            for (StorageClient sms : new StorageLister(c, this.securityProperties, (MessageWriter)this)) {
                if (!this.filterMatch(sms)) continue;
                this.listSMS(sms);
                ++lastNumberOfResults;
            }
        }
        for (StorageClient sms : new StorageLister(this.registry, this.securityProperties, (MessageWriter)this)) {
            if (!this.filterMatch(sms)) continue;
            this.listSMS(sms);
            ++lastNumberOfResults;
        }
    }

    protected void listSMS(StorageClient sms) {
        try {
            this.message(sms.getStorageName() + " " + sms.getEPR().getAddress().getStringValue() + this.getDetails(sms));
        }
        catch (Exception ex) {
            this.error("Error listing storage at " + sms.getEPR().getAddress().getStringValue(), ex);
        }
        this.printWSRFProperties(sms);
    }

    @Override
    protected String getDetails(StorageClient sms) {
        if (!this.detailed) {
            return "";
        }
        String sep = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        try {
            RangeValueType diskSpace = sms.getFileSystem().getDiskSpace();
            if (diskSpace != null && diskSpace.getExactArray() != null && diskSpace.getExactArray().length > 0) {
                double space = diskSpace.getExactArray()[0].getDoubleValue();
                sb.append(sep).append("  Available: ").append(this.unitParser.getHumanReadable(space));
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            sb.append(sep).append("  Protocols: ").append(Arrays.asList(sms.getSupportedProtocols()));
            sb.append(sep).append("  Metadata: ").append(sms.supportsMetadata() ? "yes" : "no");
            sb.append(sep).append("  ACLs: ").append(sms.supportsACL() ? "yes" : "no");
        }
        catch (Exception ex) {
            // empty catch block
        }
        return sb.toString();
    }

    @Override
    public String getDescription() {
        return "list the available remote storages";
    }

    @Override
    public String getArgumentList() {
        return "";
    }

    @Override
    public String getCommandGroup() {
        return "General";
    }

    @Override
    public QName getQName() {
        return StorageManagement.SMS_PORT;
    }

    @Override
    public String getServiceName() {
        return "Storage";
    }

    @Override
    public String getServiceDetails(EndpointReferenceType epr, IClientConfiguration securityProperties) {
        return null;
    }
}

