/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.actions;

import de.fzj.unicore.uas.client.TSSClient;
import de.fzj.unicore.ucc.UCCOptions;
import de.fzj.unicore.ucc.actions.ListActionBase;
import de.fzj.unicore.ucc.helpers.TargetSystemLister;
import eu.unicore.jsdl.extensions.ExecutionEnvironmentDescriptionDocument;
import java.util.Arrays;
import org.apache.commons.cli.OptionBuilder;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.RangeValueType;
import org.unigrids.services.atomic.types.AvailableResourceType;
import org.unigrids.services.atomic.types.AvailableResourceTypeType;
import org.unigrids.x2006.x04.services.tss.ApplicationResourceType;
import org.unigrids.x2006.x04.services.tss.TargetSystemPropertiesDocument;

public class ListSites
extends ListActionBase<TSSClient> {
    protected String siteName;
    private static String lastSiteAddress;

    @Override
    public String getName() {
        return "list-sites";
    }

    @Override
    protected void createOptions() {
        super.createOptions();
        UCCOptions uCCOptions = this.getOptions();
        OptionBuilder.withLongOpt((String)"sitename");
        OptionBuilder.withDescription((String)"Site Name");
        OptionBuilder.withArgName((String)"Vsite");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        uCCOptions.addOption(OptionBuilder.create((String)"s"));
    }

    @Override
    public void process() {
        super.process();
        this.siteName = this.getCommandLine().getOptionValue("s");
        for (TSSClient c : new TargetSystemLister(this.registry, this.securityProperties, this)) {
            if (!this.filterMatch(c)) continue;
            try {
                if (this.siteName != null && !this.siteName.equals(c.getTargetSystemName())) continue;
                this.listTSS(c);
                ++lastNumberOfResults;
            }
            catch (Exception ex) {
                this.error("Error listing site at <" + c.getEPR().getAddress().getStringValue() + ">", ex);
            }
        }
    }

    protected void listTSS(TSSClient tss) throws Exception {
        this.message(tss.getTargetSystemName() + " " + tss.getEPR().getAddress().getStringValue() + " " + this.getDetails(tss));
        this.printWSRFProperties(tss);
    }

    @Override
    protected String getDetails(TSSClient tss) throws Exception {
        String[] xgroups;
        if (!this.detailed) {
            return "";
        }
        StringBuilder details = new StringBuilder();
        String sep = System.getProperty("line.separator");
        details.append(sep).append("  Operating system: ").append(tss.getOperatingSystemInfo());
        details.append(sep).append("  Number of jobs: ").append(tss.getNumberOfJobs());
        boolean first = true;
        for (ApplicationResourceType a : tss.getApplications()) {
            if (!first) {
                details.append(", ");
            } else {
                details.append(sep).append("  Applications: ");
                first = false;
            }
            details.append(a.getApplicationName()).append(" ").append(a.getApplicationVersion());
        }
        TargetSystemPropertiesDocument.TargetSystemProperties tssProps = tss.getResourcePropertiesDocument().getTargetSystemProperties();
        first = true;
        for (ExecutionEnvironmentDescriptionDocument.ExecutionEnvironmentDescription ee : tssProps.getExecutionEnvironmentDescriptionArray()) {
            if (!first) {
                details.append(", ");
            } else {
                details.append(sep).append("  Execution environments: ");
                first = false;
            }
            details.append(ee.getName());
            if (ee.getVersion() == null) continue;
            details.append(" ").append(ee.getVersion());
        }
        String[] xlogins = tss.getXlogins();
        if (xlogins != null && xlogins.length > 0) {
            details.append(sep).append("  Xlogins: " + Arrays.asList(xlogins));
        }
        if ((xgroups = tss.getXgroups()) != null && xgroups.length > 0) {
            details.append(sep).append("  Xgroups: " + Arrays.asList(xgroups));
        }
        this.listResources(tssProps, details);
        return details.toString();
    }

    protected void listResources(TargetSystemPropertiesDocument.TargetSystemProperties tssProps, StringBuilder details) {
        String sep = System.getProperty("line.separator");
        try {
            AvailableResourceType[] aR;
            String cpus;
            String cpusPerNode;
            String nodes = this.getRange(tssProps.getTotalResourceCount());
            if (nodes != null) {
                details.append(sep).append("  Nodes: ").append(nodes);
            }
            if ((cpusPerNode = this.getRange(tssProps.getIndividualCPUCount())) != null) {
                details.append(sep).append("  CPUsPerNode: ").append(cpusPerNode);
            }
            if ((cpus = this.getRange(tssProps.getTotalResourceCount())) != null) {
                details.append(sep).append("  CPUs: ").append(cpus);
            }
            for (AvailableResourceType a : aR = tssProps.getAvailableResourceArray()) {
                details.append(sep).append("  ").append(a.getName()).append(": ").append(this.getRange(a));
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    private String getRange(RangeValueType rv) {
        if (rv == null) {
            return null;
        }
        String lower = rv.getRangeArray()[0].getLowerBound().getStringValue();
        String upper = rv.getRangeArray()[0].getUpperBound().getStringValue();
        return lower + " - " + upper;
    }

    private String getRange(AvailableResourceType res) {
        if (res == null) {
            return null;
        }
        if (AvailableResourceTypeType.INT == res.getType() || AvailableResourceTypeType.DOUBLE == res.getType()) {
            String lower = res.getMin();
            String upper = res.getMax();
            return "[" + lower + " - " + upper + "]";
        }
        if (AvailableResourceTypeType.CHOICE == res.getType()) {
            return String.valueOf(Arrays.asList(res.getAllowedValueArray()));
        }
        if (AvailableResourceTypeType.STRING == res.getType()) {
            return "string-valued";
        }
        if (AvailableResourceTypeType.BOOLEAN == res.getType()) {
            return "true|false";
        }
        return "";
    }

    @Override
    public String getDescription() {
        return "list remote sites";
    }

    @Override
    public String getArgumentList() {
        return "";
    }

    @Override
    public String getCommandGroup() {
        return "General";
    }

    @Override
    public String getSynopsis() {
        return "List the Grid sites available to you, together with some information about the site's capabilities. Use the -l or -a options to control the amount of information. Use the -s option to limit the list to a single site.";
    }

    public static String getLastSiteAddress() {
        return lastSiteAddress;
    }

    protected static void setLastSiteAddress(String lastAddress) {
        lastSiteAddress = lastAddress;
    }
}

