/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.actions;

import de.fzj.unicore.uas.client.JobClient;
import de.fzj.unicore.uas.client.TSSClient;
import de.fzj.unicore.ucc.UCCOptions;
import de.fzj.unicore.ucc.actions.ListActionBase;
import de.fzj.unicore.ucc.helpers.JobLister;
import de.fzj.unicore.ucc.helpers.TargetSystemLister;
import org.apache.commons.cli.OptionBuilder;

public class ListJobs
extends ListActionBase<JobClient> {
    protected String siteName;

    @Override
    public String getName() {
        return "list-jobs";
    }

    @Override
    protected void createOptions() {
        super.createOptions();
        UCCOptions uCCOptions = this.getOptions();
        OptionBuilder.withLongOpt((String)"sitename");
        OptionBuilder.withDescription((String)"Site Name");
        OptionBuilder.withArgName((String)"Vsite");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        uCCOptions.addOption(OptionBuilder.create((String)"s"));
    }

    @Override
    public void process() {
        super.process();
        this.siteName = this.getCommandLine().getOptionValue("s");
        for (TSSClient c : new TargetSystemLister(this.registry, this.securityProperties, this)) {
            String tName = c.getTargetSystemName();
            if (this.siteName != null && !this.siteName.equals(tName)) continue;
            this.verbose("Listing TargetSystem <" + tName + "> at " + c.getEPR().getAddress().getStringValue());
            for (JobClient job : new JobLister(c)) {
                if (!this.filterMatch(job)) continue;
                this.listJob(job);
                ++lastNumberOfResults;
            }
        }
    }

    protected void listJob(JobClient job) {
        this.message(job.getEPR().getAddress().getStringValue() + this.getDetails(job));
        this.printWSRFProperties(job);
    }

    @Override
    protected String getDetails(JobClient job) {
        if (!this.detailed) {
            return "";
        }
        try {
            return " " + job.getStatus();
        }
        catch (Exception ex) {
            return " ERROR getting status";
        }
    }

    @Override
    public String getDescription() {
        return "list your jobs";
    }

    @Override
    public String getSynopsis() {
        return "Lists your jobs per target system. The list can be limited to a single target system specified using the '-s' option.";
    }

    @Override
    public String getArgumentList() {
        return "";
    }

    @Override
    public String getCommandGroup() {
        return "General";
    }
}

