/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.actions;

import de.fzj.unicore.ucc.actions.ActionBase;
import de.fzj.unicore.ucc.helpers.AttributeAssertionFetcher;
import eu.unicore.samly2.assertion.Assertion;
import eu.unicore.samly2.exceptions.SAMLParseException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import pl.edu.icm.unicore.uvos.api.Attribute;
import pl.edu.icm.unicore.uvos.api.Group;
import pl.edu.icm.unicore.uvos.api.exceptions.AttributeNotFoundException;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.SAMLXMLBeansMapper;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.UnsupportedSAMLException;
import pl.edu.icm.unicore.uvos.wsclient.samlapi.InvalidSignatureException;
import pl.edu.icm.unicore.uvos.wsclient.samlapi.InvocationException;
import pl.edu.icm.unicore.uvos.wsclient.samlapi.SAMLErrorResponseException;
import pl.edu.icm.unicore.uvos.wsclient.samlapi.SAMLVOQueryClient;
import pl.edu.icm.unicore.uvos.wsclient.samlapi.SecuritySetupException;

public class ListAttributes
extends ActionBase {
    private static final int MINIMUM_TABLE_WIDTH = 63;
    public static final Comparator<Attribute> ATTRIBUTE_COMPARATOR = new Comparator<Attribute>(){

        @Override
        public int compare(Attribute t, Attribute t1) {
            int n = t.getName().compareTo(t1.getName());
            if (n != 0) {
                return n;
            }
            if (t.getScope() == null && t1.getScope() != null) {
                return -1;
            }
            if (t.getScope() != null && t1.getScope() == null) {
                return 1;
            }
            if (t.getScope() == null && t1.getScope() == null) {
                return 0;
            }
            return t.getScope().compareTo(t1.getScope());
        }
    };

    @Override
    public String getName() {
        return "list-attributes";
    }

    @Override
    protected void createOptions() {
        super.createOptions();
    }

    @Override
    public String getDescription() {
        return "list VO attributes of the user";
    }

    @Override
    public String getCommandGroup() {
        return "Security";
    }

    @Override
    public String getSynopsis() {
        return "List ALL VO attributes. If given a VO URL with the option -J, the assertion is fetched from the VO server first. If given a file name with the option -A, the assertion is loaded from that file. All attributes in the assertion are displayed in human readable table. The table also indicates whether the attribute would be included or not when using the scope and filter settings, which were provided to this command.";
    }

    @Override
    protected boolean skipConnectingToRegistry() {
        return null != this.getOption("attributeAssertion", "A") || !"auto".equals(this.getOption("VO", "J"));
    }

    public void prettyPrint(List<Attribute> la) {
        ArrayList<String> scopeColumn = new ArrayList<String>();
        ArrayList<String> nameColumn = new ArrayList<String>();
        ArrayList<String> valueColumn = new ArrayList<String>();
        ArrayList<String> filteredColumn = new ArrayList<String>();
        ArrayList<String> descriptions = new ArrayList<String>();
        scopeColumn.add("Scope");
        nameColumn.add("Name");
        valueColumn.add("Value");
        filteredColumn.add("F");
        Collections.sort(la, ATTRIBUTE_COMPARATOR);
        List<Attribute> filteredByName = this.attributeFilter.filter(la);
        String groupS = this.getOption("voGroup", "G", null);
        Group group = null;
        if (groupS != null) {
            group = new Group(groupS);
        }
        String latestName = "";
        for (Attribute attr : la) {
            List attrValue = attr.getValues();
            String attrScope = attr.getScope();
            String attrName = attr.getName();
            if (ListAttributes.equal(latestName, attrName)) {
                attrName = "";
            } else {
                scopeColumn.add(null);
                nameColumn.add(null);
                valueColumn.add(null);
                filteredColumn.add(null);
                latestName = attrName;
                String description = attr.getType().getDescription();
                if (description == null) {
                    description = attr.getType().getShortDescription();
                }
                if (description != null && !"".equals(description)) {
                    nameColumn.add("<D>");
                    valueColumn.add(Integer.toString(descriptions.size()));
                    scopeColumn.add("");
                    filteredColumn.add("");
                    descriptions.add(description);
                    scopeColumn.add(null);
                    nameColumn.add(null);
                    valueColumn.add(null);
                    filteredColumn.add(null);
                }
            }
            nameColumn.add(attrName);
            if (attrScope == null) {
                attrScope = "<GLOBAL>";
            }
            scopeColumn.add(attrScope);
            boolean scopeFiltered = false;
            if (group != null) {
                scopeFiltered = !SAMLVOQueryClient.isInScope((Attribute)attr, (Group)group, (boolean)true, (String)groupS);
            }
            for (int cc = 1; cc < attrValue.size(); ++cc) {
                nameColumn.add("");
                scopeColumn.add("");
            }
            List filteredValues = Collections.emptyList();
            boolean attributeFullyFiltered = true;
            for (Attribute filteredAttr : filteredByName) {
                if (!ListAttributes.equal(filteredAttr.getName(), attr.getName()) || !ListAttributes.equal(filteredAttr.getScope(), attr.getScope())) continue;
                filteredValues = filteredAttr.getValues();
                attributeFullyFiltered = false;
                break;
            }
            if (attrValue.isEmpty()) {
                valueColumn.add("<no values>");
                if (!scopeFiltered && !attributeFullyFiltered) {
                    filteredColumn.add(" ");
                } else if (scopeFiltered && !attributeFullyFiltered) {
                    filteredColumn.add("S");
                } else if (!scopeFiltered && attributeFullyFiltered) {
                    filteredColumn.add("N");
                } else {
                    filteredColumn.add("B");
                }
            }
            for (String v : attrValue) {
                valueColumn.add(v);
                if (filteredValues.contains(v)) {
                    if (!scopeFiltered) {
                        filteredColumn.add(" ");
                        continue;
                    }
                    filteredColumn.add("S");
                    continue;
                }
                if (!scopeFiltered) {
                    filteredColumn.add("N");
                    continue;
                }
                filteredColumn.add("B");
            }
        }
        scopeColumn.add(null);
        nameColumn.add(null);
        valueColumn.add(null);
        filteredColumn.add(null);
        ListAttributes.normalize(scopeColumn, 0);
        ListAttributes.normalize(nameColumn, 0);
        ListAttributes.normalize(valueColumn, 0);
        ListAttributes.normalize(filteredColumn, 63 - nameColumn.get(0).length() - scopeColumn.get(0).length() - valueColumn.get(0).length() - 3);
        for (int i = 0; i < nameColumn.size(); ++i) {
            if (nameColumn.get(i).startsWith("<D>")) {
                int width = scopeColumn.get(i).length() + nameColumn.get(i).length() + filteredColumn.get(i).length() + valueColumn.get(i).length() + 3;
                this.message(this.wrap((String)descriptions.get(Integer.parseInt(valueColumn.get(i).trim())), width));
                continue;
            }
            this.message(nameColumn.get(i) + "|" + scopeColumn.get(i) + "|" + valueColumn.get(i) + "|" + filteredColumn.get(i));
        }
        this.message("");
        this.message("The last column shows whether the attribute would be excluded by the current filtering settings, which were:");
        this.message("- filtering by group scope: " + (groupS == null ? "NONE" : groupS));
        this.message("- name/value filters: " + this.attributeFilter.toString());
        this.message("Legend: S - excluded by scope, N - excluded by name/value, B - excluded by both scope and name/value");
    }

    @Override
    public void process() {
        super.process();
        if ((this.voURL == null || this.voURL.isEmpty()) && (this.attrAssertionFilename == null || this.attrAssertionFilename.isEmpty())) {
            this.message("Cannot list attributes without attribute source. Set VO server or use file contatining an assertion.");
            this.endProcessing(1);
        }
        try {
            this.verbose("Connecting to VO " + this.voURL);
            AttributeAssertionFetcher fetcher = new AttributeAssertionFetcher(this.securityProperties, this.voURL);
            Assertion fullAssertion = fetcher.fetchAssertion(null, null);
            List la = SAMLXMLBeansMapper.convertSAMLAttributes2API((Assertion)fullAssertion);
            this.prettyPrint(la);
        }
        catch (SAMLParseException ex) {
            this.error("Malformed SAML response", ex);
            this.endProcessing(1);
        }
        catch (UnsupportedSAMLException ex) {
            this.error("Received SAML response contains unsupported SAML features", ex);
            this.endProcessing(1);
        }
        catch (InvalidSignatureException ex) {
            this.error("Error in processing SAML signature", ex);
            this.endProcessing(1);
        }
        catch (InvocationException ex) {
            this.error("Error communicating with remote service", ex);
            this.endProcessing(1);
        }
        catch (SAMLErrorResponseException ex) {
            this.error("Received SAML error: " + ex.toString(), ex);
            this.endProcessing(1);
        }
        catch (SecuritySetupException ex) {
            this.error("Invalid configuration of security: " + ex.getMessage(), ex);
            this.endProcessing(1);
        }
        catch (MalformedURLException ex) {
            this.error("Invalid syntax of the VO URL: " + this.voURL, ex);
            this.endProcessing(1);
        }
        catch (AttributeNotFoundException e) {
            this.error("Shouldn't happen - BUG: implementation filtered all attributes, while should filter none.", e);
            this.endProcessing(1);
        }
    }

    @Override
    protected void fetchAssertionFromServer() {
    }

    private static void normalize(ArrayList<String> list, int minWidth) {
        int max = minWidth;
        for (String s : list) {
            if (s == null || s.length() <= max) continue;
            max = s.length();
        }
        char[] tmp = new char[max];
        Arrays.fill(tmp, ' ');
        String spaces = new String(tmp);
        Arrays.fill(tmp, '-');
        String minuses = new String(tmp);
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) == null) {
                list.set(i, minuses);
                continue;
            }
            int l = list.get(i).length();
            if (l >= max) continue;
            list.set(i, list.get(i) + spaces.substring(0, max - l));
        }
    }

    private static boolean equal(String s1, String s2) {
        return s1 == null && s2 == null || s1 != null && s1.equals(s2);
    }

    private String wrap(String orig, int width) {
        return orig;
    }
}

