/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.actions;

import de.fzj.unicore.uas.client.TSSClient;
import de.fzj.unicore.ucc.UCCOptions;
import de.fzj.unicore.ucc.actions.ListActionBase;
import de.fzj.unicore.ucc.helpers.TargetSystemLister;
import org.apache.commons.cli.OptionBuilder;
import org.unigrids.x2006.x04.services.tss.ApplicationResourceType;

public class ListApplications
extends ListActionBase<TSSClient> {
    protected String siteName;

    @Override
    public String getName() {
        return "list-applications";
    }

    @Override
    protected void createOptions() {
        super.createOptions();
        UCCOptions uCCOptions = this.getOptions();
        OptionBuilder.withLongOpt((String)"sitename");
        OptionBuilder.withDescription((String)"Site Name");
        OptionBuilder.withArgName((String)"Vsite");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        uCCOptions.addOption(OptionBuilder.create((String)"s"));
    }

    @Override
    public void process() {
        super.process();
        this.siteName = this.getCommandLine().getOptionValue("s");
        for (TSSClient c : new TargetSystemLister(this.registry, this.securityProperties, this)) {
            try {
                String tName = c.getTargetSystemName();
                if (this.siteName != null && !this.siteName.equals(tName) || !this.filterMatch(c)) continue;
                this.verbose("Listing TargetSystem <" + tName + "> at " + c.getEPR().getAddress().getStringValue());
                this.message("Applications on target system <" + tName + ">");
                this.listApps(c);
            }
            catch (Exception ex) {
                String msg = "Error accessing TSS at " + c.getUrl();
                logger.error((Object)msg, (Throwable)ex);
                this.verbose(msg);
            }
        }
    }

    protected void listApps(TSSClient tss) {
        for (ApplicationResourceType app : tss.getApplications()) {
            String out = app.getApplicationName() + " " + app.getApplicationVersion();
            if (app.getDescription() != null) {
                out = out + " (" + app.getDescription() + ")";
            }
            this.message(out);
            ++lastNumberOfResults;
        }
    }

    @Override
    public String getDescription() {
        return "lists applications on target systems";
    }

    @Override
    public String getSynopsis() {
        return "Lists the available applications per target system. The list can be limited to a single target system specified using the '-s' option.";
    }

    @Override
    public String getArgumentList() {
        return "";
    }

    @Override
    public String getCommandGroup() {
        return "General";
    }
}

