/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.actions;

import de.fzj.unicore.ucc.UCCOptions;
import de.fzj.unicore.ucc.actions.ActionBase;
import de.fzj.unicore.ucc.util.Filter;
import de.fzj.unicore.ucc.util.PropertyFilter;
import de.fzj.unicore.wsrflite.xmlbeans.client.BaseWSRFClient;
import org.apache.commons.cli.OptionBuilder;

public abstract class ListActionBase<T extends BaseWSRFClient>
extends ActionBase {
    protected boolean detailed;
    protected boolean all;
    protected boolean doFilter;
    protected Filter filter;
    protected static int lastNumberOfResults;

    @Override
    protected void createOptions() {
        super.createOptions();
        UCCOptions uCCOptions = this.getOptions();
        OptionBuilder.withLongOpt((String)"filter");
        OptionBuilder.withDescription((String)"Filter the list");
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.hasArgs();
        uCCOptions.addOption(OptionBuilder.create((String)"f"));
        UCCOptions uCCOptions2 = this.getOptions();
        OptionBuilder.withLongOpt((String)"long");
        OptionBuilder.withDescription((String)"Detailed output");
        OptionBuilder.isRequired((boolean)false);
        uCCOptions2.addOption(OptionBuilder.create((String)"l"));
        UCCOptions uCCOptions3 = this.getOptions();
        OptionBuilder.withLongOpt((String)"all");
        OptionBuilder.withDescription((String)"Print all properties");
        OptionBuilder.isRequired((boolean)false);
        uCCOptions3.addOption(OptionBuilder.create((String)"a"));
    }

    @Override
    public void process() {
        super.process();
        lastNumberOfResults = 0;
        this.doFilter = this.getCommandLine().hasOption("f");
        this.verbose("Filtering = " + this.doFilter);
        this.detailed = this.getBooleanOption("long", "l");
        this.verbose("Detailed listing = " + this.detailed);
        this.all = this.getBooleanOption("all", "a");
        this.verbose("Printing WSRF properties = " + this.all);
        if (this.doFilter) {
            this.filter = this.createFilter(this.getCommandLine().getOptionValues("f"));
        }
    }

    protected String getDetails(T entry) throws Exception {
        return "";
    }

    protected void printWSRFProperties(T entry) {
        if (this.all) {
            try {
                this.message(entry.getResourcePropertyDocument());
            }
            catch (Exception e) {
                this.error("Could not get resource properties!", e);
                this.endProcessing(1);
            }
        }
    }

    protected Filter createFilter(String[] args) {
        this.filter = PropertyFilter.Factory.create(this, args);
        if (this.filter == null) {
            this.verbose("Filtering parameters not understood --- not filtering.");
            this.doFilter = false;
        }
        return this.filter;
    }

    protected boolean filterMatch(T resource) {
        if (!this.doFilter) {
            return true;
        }
        return this.filter.filterMatches((BaseWSRFClient)resource);
    }

    static int getLastNumberOfResults() {
        return lastNumberOfResults;
    }
}

