/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.actions;

import de.fzj.unicore.uas.client.MetadataClient;
import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.ucc.UCCOptions;
import de.fzj.unicore.ucc.actions.SMSOperation;
import de.fzj.unicore.ucc.util.JSONUtil;
import de.fzj.unicore.ucc.util.UnitParser;
import java.util.Calendar;
import org.apache.commons.cli.OptionBuilder;
import org.json.JSONException;
import org.json.JSONObject;
import org.unigrids.services.atomic.types.GridFileType;
import org.unigrids.services.atomic.types.MetadataType;

public class LS
extends SMSOperation {
    protected boolean detailed;
    protected boolean recurse;
    protected boolean human;
    protected boolean showMetadata;
    protected UnitParser unitParser = UnitParser.getCapacitiesParser(1);
    protected StorageClient sms;
    static GridFileType lastLS;

    @Override
    public String getName() {
        return "ls";
    }

    @Override
    protected void createOptions() {
        super.createOptions();
        UCCOptions uCCOptions = this.getOptions();
        OptionBuilder.withLongOpt((String)"long");
        OptionBuilder.withDescription((String)"detailed listing");
        OptionBuilder.isRequired((boolean)false);
        uCCOptions.addOption(OptionBuilder.create((String)"l"));
        UCCOptions uCCOptions2 = this.getOptions();
        OptionBuilder.withLongOpt((String)"recursive");
        OptionBuilder.withDescription((String)"recurse into subdirectories");
        OptionBuilder.isRequired((boolean)false);
        uCCOptions2.addOption(OptionBuilder.create((String)"R"));
        UCCOptions uCCOptions3 = this.getOptions();
        OptionBuilder.withLongOpt((String)"human");
        OptionBuilder.withDescription((String)"human-friendly format");
        OptionBuilder.isRequired((boolean)false);
        uCCOptions3.addOption(OptionBuilder.create((String)"H"));
        UCCOptions uCCOptions4 = this.getOptions();
        OptionBuilder.withLongOpt((String)"show-metadata");
        OptionBuilder.withDescription((String)"Show metadata");
        OptionBuilder.isRequired((boolean)false);
        uCCOptions4.addOption(OptionBuilder.create((String)"m"));
    }

    @Override
    public void process() {
        super.process();
        this.detailed = this.getBooleanOption("long", "l");
        if (this.detailed) {
            this.verbose("Detailed listing.");
        }
        this.recurse = this.getBooleanOption("recursive", "R");
        if (this.recurse) {
            this.verbose("Listing subdirectories.");
        }
        this.human = this.getBooleanOption("human", "H");
        if (this.human) {
            this.verbose("Human friendly number format.");
        }
        this.showMetadata = this.getBooleanOption("show-metadata", "m");
        if (this.showMetadata) {
            this.verbose("Showing metadata.");
        }
        this.doProcess();
    }

    protected void doProcess() {
        if (this.getCommandLine().getArgs().length < 2) {
            this.message("Please provide a storage address!");
            this.printUsage();
            this.endProcessing(2);
        }
        String address = this.getCommandLine().getArgs()[1];
        this.sms = this.getStorageClient(address);
        String path = this.getPathAtStorage(address);
        if (path == null && this.getCommandLine().getArgs().length > 2) {
            path = this.getCommandLine().getArgs()[2];
        }
        if (path == null) {
            path = "/";
        }
        this.doListing(path);
    }

    protected void doListing(String path) {
        GridFileType listing = null;
        try {
            listing = this.sms.listProperties(path);
        }
        catch (Exception e) {
            this.error("Error getting properties for path: " + path, e);
            this.endProcessing(1);
        }
        if (listing.getIsDirectory()) {
            this.listDirectory(path);
        } else {
            this.listSingleFile(listing);
        }
    }

    protected void listDirectory(String path) {
        try {
            GridFileType[] listing;
            for (GridFileType f : listing = this.sms.listDirectory(path)) {
                this.listSingleFile(f);
                if (!f.getIsDirectory() || !this.recurse) continue;
                this.doListing(f.getPath());
            }
        }
        catch (Exception e) {
            this.error("Error listing path: " + path, e);
            this.endProcessing(1);
        }
    }

    protected void listSingleFile(GridFileType file) {
        lastLS = file;
        this.message(this.detailed ? this.detailedListing(file) : this.normalListing(file));
        if (!file.getIsDirectory() && this.showMetadata && file.getMetadata() != null) {
            try {
                this.printMetadata(file.getMetadata());
            }
            catch (Exception ex) {
                logger.error((Object)("Error printing metadata for " + file), (Throwable)ex);
                this.message("Error! Can't print metadata.");
            }
        }
    }

    protected void printMetadata(MetadataType meta) throws JSONException {
        JSONObject o = JSONUtil.asJSON(MetadataClient.asMap((MetadataType)meta));
        this.message(o.toString(2));
    }

    protected String normalListing(GridFileType f) {
        return f.getPath();
    }

    public String detailedListing(GridFileType f) {
        Calendar lastMod;
        String d;
        String r = " ";
        String w = " ";
        String x = " ";
        String string = d = f.getIsDirectory() ? "d" : "-";
        if (f.getPermissions() != null) {
            r = f.getPermissions().getReadable() ? "r" : "-";
            w = f.getPermissions().getWritable() ? "w" : "-";
            x = f.getPermissions().getExecutable() ? "x" : "-";
        }
        String lastModification = (lastMod = f.getLastModified()) != null ? this.format(lastMod) : "";
        String size = this.human ? this.unitParser.getHumanReadable(f.getSize()) : String.valueOf(f.getSize());
        return String.format("%1$1s%2$1s%3$1s%4$1s %5$14s %6$s %7$-30s", d, r, w, x, size, lastModification, f.getPath());
    }

    @Override
    public String getDescription() {
        return "list a storage";
    }

    @Override
    public String getSynopsis() {
        return "Lists files on a storage. The storage can be given by EPR or using the unicore6:// URL notation.";
    }

    @Override
    public String getArgumentList() {
        return "<EPR or u6://...> [path]";
    }

    public String format(Calendar c) {
        return UnitParser.getSimpleDateFormat().format(c.getTime());
    }

    @Override
    public String getCommandGroup() {
        return "Data management";
    }

    static GridFileType getLastLS() {
        return lastLS;
    }
}

