/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.actions;

import de.fzj.unicore.uas.client.TSSClient;
import de.fzj.unicore.ucc.UCCOptions;
import de.fzj.unicore.ucc.actions.ActionBase;
import de.fzj.unicore.ucc.helpers.TargetSystemLister;
import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import eu.unicore.security.UnicoreSecurityFactory;
import eu.unicore.security.etd.DelegationRestrictions;
import eu.unicore.security.etd.TrustDelegation;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.cli.OptionBuilder;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class IssueTD
extends ActionBase {
    private String subject;
    private int validity;
    private String target;

    @Override
    protected void createOptions() {
        super.createOptions();
        UCCOptions uCCOptions = this.getOptions();
        OptionBuilder.withLongOpt((String)"file");
        OptionBuilder.withDescription((String)"File containing the public key of the receiver of the delegation");
        OptionBuilder.withArgName((String)"Certfile");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        uCCOptions.addOption(OptionBuilder.create((String)"f"));
        UCCOptions uCCOptions2 = this.getOptions();
        OptionBuilder.withLongOpt((String)"subject");
        OptionBuilder.withDescription((String)"The distinguished name (DN) of the receiver of the delegation");
        OptionBuilder.withArgName((String)"SubjectDN");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        uCCOptions2.addOption(OptionBuilder.create((String)"S"));
        UCCOptions uCCOptions3 = this.getOptions();
        OptionBuilder.withLongOpt((String)"target");
        OptionBuilder.withDescription((String)"The target file for storing the assertion");
        OptionBuilder.withArgName((String)"Targetfile");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        uCCOptions3.addOption(OptionBuilder.create((String)"t"));
        UCCOptions uCCOptions4 = this.getOptions();
        OptionBuilder.withLongOpt((String)"validity");
        OptionBuilder.withDescription((String)"The number of days that the delegation stays valid (default: 1)");
        OptionBuilder.withArgName((String)"Validity_Days");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        uCCOptions4.addOption(OptionBuilder.create((String)"V"));
        UCCOptions uCCOptions5 = this.getOptions();
        OptionBuilder.withLongOpt((String)"sitename");
        OptionBuilder.withDescription((String)"The name of the site to delegate trust to");
        OptionBuilder.withArgName((String)"Site name");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        uCCOptions5.addOption(OptionBuilder.create((String)"s"));
    }

    @Override
    protected boolean skipConnectingToRegistry() {
        return !this.getCommandLine().hasOption("s");
    }

    @Override
    public void process() {
        super.process();
        try {
            this.validity = Integer.parseInt(this.getOption("validity", "V", "1"));
            if (this.getCommandLine().hasOption("f")) {
                String pemFile = this.getOption("file", "f");
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                FileInputStream inStream = new FileInputStream(pemFile);
                X509Certificate cert = (X509Certificate)cf.generateCertificate(inStream);
                this.subject = cert.getSubjectX500Principal().getName();
            } else if (this.getCommandLine().hasOption("S")) {
                this.subject = this.getCommandLine().getOptionValue("S");
            } else if (this.getCommandLine().hasOption("s")) {
                String siteName = this.getCommandLine().getOptionValue("s");
                this.findSubjectBySiteName(siteName);
            } else {
                this.printUsage();
                throw new IllegalArgumentException("Must specify one of: cert file, subject DN or site name.");
            }
            this.target = this.getOption("target", "t", "td.out");
            this.doIssueTD();
        }
        catch (Exception e) {
            this.error("Can't issue trust delegation.", e);
            this.endProcessing(2);
        }
    }

    protected void findSubjectBySiteName(String siteName) {
        super.testRegistryConnection();
        TSSClient t = new TargetSystemLister(this.registry, this.securityProperties, this).getTSS(siteName);
        EndpointReferenceType epr = t.getEPR();
        this.verbose("Using server at " + epr.getAddress().getStringValue());
        this.subject = new X500Principal(WSUtilities.extractServerIDFromEPR((EndpointReferenceType)epr)).getName();
    }

    @Override
    protected boolean requireRegistry() {
        return false;
    }

    protected TrustDelegation doIssueTD() throws Exception {
        DelegationRestrictions restr = new DelegationRestrictions(new Date(), this.validity, 10);
        TrustDelegation td = UnicoreSecurityFactory.getETDEngine().generateTD(this.securityProperties.getCredential().getSubjectName(), this.securityProperties.getCredential().getCertificateChain(), this.securityProperties.getCredential().getKey(), this.subject, restr);
        FileOutputStream fos = new FileOutputStream(this.target);
        td.getXML().save((OutputStream)fos);
        fos.close();
        return td;
    }

    @Override
    public String getName() {
        return "issue-delegation";
    }

    @Override
    public String getArgumentList() {
        return "<cert_file> <target_file> [<validity_days>] ";
    }

    @Override
    public String getSynopsis() {
        return "Issue a trust delegation assertion from the current user to the subject specified in the cert_file. The assertion will be saved to target_file. If not specified the validity is one day.";
    }

    @Override
    public String getDescription() {
        return "issue trust delegation assertion";
    }

    @Override
    public String getCommandGroup() {
        return "Security";
    }
}

