/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.actions;

import de.fzj.unicore.ucc.UCCOptions;
import de.fzj.unicore.ucc.actions.ActionBase;
import groovy.lang.GroovyShell;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.cli.OptionBuilder;
import org.codehaus.groovy.control.CompilerConfiguration;

public class Groovy
extends ActionBase {
    protected String expression;

    @Override
    protected void createOptions() {
        super.createOptions();
        UCCOptions uCCOptions = this.getOptions();
        OptionBuilder.withLongOpt((String)"file");
        OptionBuilder.withDescription((String)"File containing the Groovy script");
        OptionBuilder.withArgName((String)"Script");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        uCCOptions.addOption(OptionBuilder.create((String)"f"));
        UCCOptions uCCOptions2 = this.getOptions();
        OptionBuilder.withLongOpt((String)"expression");
        OptionBuilder.withDescription((String)"the Groovy expression");
        OptionBuilder.withArgName((String)"Expression");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        uCCOptions2.addOption(OptionBuilder.create((String)"e"));
    }

    @Override
    public void process() {
        super.process();
        CompilerConfiguration conf = new CompilerConfiguration();
        conf.setScriptBaseClass("de.fzj.unicore.ucc.helpers.Base");
        GroovyShell shell = new GroovyShell(conf);
        shell.setProperty("registry", (Object)this.registry);
        shell.setProperty("securityProperties", (Object)this.securityProperties);
        shell.setProperty("registryURL", (Object)this.registryURL);
        shell.setProperty("properties", (Object)this.properties);
        shell.setProperty("options", (Object)this.getOptions());
        shell.setProperty("commandLine", (Object)this.getCommandLine());
        shell.setProperty("messageWriter", (Object)this);
        if (this.getCommandLine().hasOption("e")) {
            this.expression = this.getCommandLine().getOptionValue("e");
        } else if (this.getCommandLine().hasOption("f")) {
            try {
                this.expression = this.readFile(this.getCommandLine().getOptionValue("f"));
            }
            catch (Exception e) {
                this.error("Can't read file, or file not given.", e);
                this.endProcessing(2);
            }
        } else {
            this.getFallbackGroovyExpression();
        }
        shell.evaluate(this.expression);
    }

    public void getFallbackGroovyExpression() {
        this.printUsage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFile(String name) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        BufferedInputStream fis = new BufferedInputStream(new FileInputStream(new File(name).getAbsolutePath()));
        try {
            int b = 0;
            while ((b = ((InputStream)fis).read()) != -1) {
                bos.write(b);
            }
            String string = bos.toString();
            return string;
        }
        finally {
            try {
                ((InputStream)fis).close();
            }
            catch (Exception e) {}
        }
    }

    @Override
    public String getName() {
        return "run-groovy";
    }

    @Override
    public String getSynopsis() {
        return "Runs a Groovy script file (specified using '-f') or expression (specified using '-e').";
    }

    @Override
    public String getDescription() {
        return "run a Groovy script";
    }

    @Override
    public String getArgumentList() {
        return "<script_args>";
    }

    @Override
    protected boolean requireRegistry() {
        return false;
    }
}

