/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.actions;

import de.fzj.unicore.uas.client.JobClient;
import de.fzj.unicore.ucc.actions.ActionBase;
import de.fzj.unicore.ucc.util.Builder;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.unigrids.services.atomic.types.StatusType;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class GetStatus
extends ActionBase {
    static String lastStatus;
    static boolean allSuccessful;

    protected JobClient createJobClient(String arg) {
        JobClient job = null;
        Builder builder = this.createBuilder(arg);
        String url = builder.getProperty("epr");
        if (url == null) {
            this.error("Job EPR not found! Maybe <" + arg + "> has not been produced by ucc.", null);
            this.endProcessing(2);
        }
        try {
            EndpointReferenceType epr = EndpointReferenceType.Factory.newInstance();
            epr.addNewAddress().setStringValue(url);
            job = new JobClient(url, epr, this.securityProperties);
            job.getCurrentTime();
            this.verbose("Job ID OK.");
        }
        catch (Exception e) {
            this.error("Can't contact job", e);
            this.endProcessing(1);
        }
        return job;
    }

    protected Builder createBuilder(String arg) {
        Builder builder = null;
        try {
            File job = new File(arg);
            if (job.exists()) {
                builder = new Builder(job);
                builder.setCheckLocalFiles(false);
                this.verbose("Read job from <" + arg + ">");
            } else {
                this.verbose("Accessing job at EPR = <" + arg + ">");
                builder = new Builder();
                builder.setCheckLocalFiles(false);
                builder.setProperty("epr", arg);
            }
        }
        catch (Exception e) {
            this.error("Can't use <" + arg + ">.", e);
            this.endProcessing(2);
        }
        return builder;
    }

    @Override
    public void process() {
        super.process();
        allSuccessful = true;
        ArrayList<String> args = new ArrayList<String>();
        if (this.getCommandLine().getArgs().length == 1) {
            try {
                String arg = new BufferedReader(new InputStreamReader(System.in)).readLine();
                args.add(arg);
            }
            catch (Exception e) {
                this.error("Can't read job descriptor from stdin.", e);
                this.endProcessing(2);
            }
        } else {
            for (int i = 1; i < this.getCommandLine().getArgs().length; ++i) {
                args.add(this.getCommandLine().getArgs()[i]);
            }
        }
        for (String arg : args) {
            JobClient job = this.createJobClient(arg);
            this.getStatus(job);
        }
    }

    @Override
    public String getName() {
        return "get-status";
    }

    @Override
    public String getArgumentList() {
        return "[<jobfile> | <jobepr>]";
    }

    @Override
    public String getSynopsis() {
        return "Gets the status of a UNICORE 6 job. The job is referenced either by a job file as written by the 'run' command or as an EPR.";
    }

    @Override
    public String getDescription() {
        return "get job status";
    }

    @Override
    public String getCommandGroup() {
        return "Job execution";
    }

    protected void getStatus(JobClient job) {
        try {
            Float progress;
            Integer exit;
            StatusType.Enum status = job.getStatus();
            String url = job.getEPR().getAddress().getStringValue();
            StringBuilder sb = new StringBuilder();
            sb.append(url).append(" ");
            sb.append(status);
            if (!status.equals(StatusType.SUCCESSFUL)) {
                allSuccessful = false;
            }
            if (status.equals(StatusType.SUCCESSFUL) && (exit = job.getExitCode()) != null) {
                sb.append(" exit code: " + exit);
            }
            if (status.equals(StatusType.RUNNING) && (progress = job.getProgress()) != null) {
                sb.append(" progress: " + (int)(100.0f * progress.floatValue()) + "%");
            }
            lastStatus = sb.toString();
            this.message(sb.toString());
        }
        catch (Exception e) {
            this.error("Can't get job status.", e);
            this.endProcessing(1);
        }
    }
}

