/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.actions;

import de.fzj.unicore.ucc.actions.Run;
import de.fzj.unicore.ucc.runner.Runner;
import de.fzj.unicore.ucc.util.Builder;
import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;

public class GetOutcome
extends Run {
    @Override
    protected void initBuilder(String arg) {
        try {
            File job = new File(arg);
            if (job.exists()) {
                this.builder = new Builder(job);
                this.builder.setCheckLocalFiles(false);
                this.verbose("Read job from <" + arg + ">");
            } else {
                this.verbose("Accessing job at EPR = <" + arg + ">");
                this.builder = new Builder();
                this.builder.setCheckLocalFiles(false);
                this.builder.setProperty("epr", arg);
                this.builder.setProperty("id", WSUtilities.extractResourceID((String)arg));
            }
        }
        catch (Exception e) {
            this.error("Can't use <" + arg + ">.", e);
            this.endProcessing(2);
        }
    }

    @Override
    protected void initBuilderFromStdin() {
        String arg = null;
        try {
            arg = new BufferedReader(new InputStreamReader(System.in)).readLine();
            this.initBuilder(arg);
        }
        catch (Exception e) {
            System.err.println("Can't read job EPR from stdin.");
            this.endProcessing(2);
        }
    }

    @Override
    public String getName() {
        return "get-output";
    }

    @Override
    public String getArgumentList() {
        return "[<jobfile> | <jobepr>]";
    }

    @Override
    public String getSynopsis() {
        return "Gets the output of a UNICORE 6 job. The job is referenced either by a job file as written by the run-job command or as an EPR.";
    }

    @Override
    public String getDescription() {
        return "get output files";
    }

    @Override
    public String getCommandGroup() {
        return "Job execution";
    }

    @Override
    protected void run() {
        try {
            this.builder.setProperty("state", "STARTED");
            this.builder.setProperty("Output", this.output.getAbsolutePath());
            this.builder.setProperty("IDLocation", this.output.getAbsolutePath());
            this.runner = new Runner(this.registry, this.securityProperties, this.builder);
            this.runner.setBriefOutfileNames(this.brief);
            this.runner.setProperties(this.properties);
            this.runner.run();
        }
        catch (Exception e) {
            this.error("Error getting output", e);
            this.endProcessing(1);
        }
    }
}

