/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.actions;

import de.fzj.unicore.uas.client.MetadataClient;
import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.ucc.UCCOptions;
import de.fzj.unicore.ucc.actions.SMSOperation;
import de.fzj.unicore.ucc.util.JSONUtil;
import de.fzj.unicore.ucc.util.UnitParser;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.json.JSONException;
import org.json.JSONObject;
import org.unigrids.services.atomic.types.ACLEntryType;
import org.unigrids.services.atomic.types.ACLEntryTypeType;
import org.unigrids.services.atomic.types.GridFileType;
import org.unigrids.services.atomic.types.MetadataType;

public class GetFileProperties
extends SMSOperation {
    protected DateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    protected UnitParser unitParser = UnitParser.getCapacitiesParser(1);

    @Override
    protected void createOptions() {
        super.createOptions();
        UCCOptions uCCOptions = this.getOptions();
        OptionBuilder.withLongOpt((String)"human");
        OptionBuilder.withDescription((String)"human-friendly format");
        OptionBuilder.isRequired((boolean)false);
        uCCOptions.addOption(OptionBuilder.create((String)"H"));
        UCCOptions uCCOptions2 = this.getOptions();
        OptionBuilder.withLongOpt((String)"show-metadata");
        OptionBuilder.withDescription((String)"Show metadata");
        OptionBuilder.isRequired((boolean)false);
        uCCOptions2.addOption(OptionBuilder.create((String)"m"));
    }

    @Override
    public String getName() {
        return "stat";
    }

    @Override
    public String getSynopsis() {
        return "Retrieves file status: permissions, ACL, owner and more.";
    }

    @Override
    public String getDescription() {
        return "show detailed file information";
    }

    @Override
    public String getArgumentList() {
        return "<[Storage-URL#]/path or [u6://SITENAME/[JobId|StorageName]]/path>";
    }

    @Override
    public String getCommandGroup() {
        return "Data management";
    }

    @Override
    public void process() {
        CommandLine cmdLine;
        boolean showMetadata;
        super.process();
        boolean human = this.getBooleanOption("human", "H");
        if (human) {
            this.verbose("Human friendly number format.");
        }
        if (showMetadata = this.getBooleanOption("show-metadata", "m")) {
            this.verbose("Showing metadata.");
        }
        if ((cmdLine = this.getCommandLine()).getArgs().length != 2) {
            this.error("Wrong number of arguments", null);
            this.printUsage();
            this.endProcessing(2);
        }
        String target = cmdLine.getArgs()[1];
        this.verbose("Getting file properties of " + target);
        StorageClient sms = this.getStorageClient(target);
        try {
            GridFileType gridFile = sms.listProperties(this.getPathAtStorage(target));
            String msg = this.formatStat(gridFile, human, showMetadata);
            this.message(msg);
        }
        catch (Exception ex) {
            this.error("Error while getting file properties.", ex);
            this.endProcessing(1);
        }
    }

    private String formatStat(GridFileType f, boolean human, boolean showMetadata) {
        Calendar lastMod = f.getLastModified();
        String lastModification = lastMod != null ? this.dateFormatter.format(lastMod.getTime()) : "";
        String size = human ? this.unitParser.getHumanReadable(f.getSize()) : String.valueOf(f.getSize());
        String type = f.getIsDirectory() ? "directory" : "normal file";
        StringBuilder sb = new StringBuilder();
        sb.append("File: ").append(f.getPath()).append("\n");
        sb.append("Size: ").append(size).append("\n");
        sb.append("Type: ").append(type).append("\n");
        if (f.getOwner() != null) {
            sb.append("Owner uid: ").append(f.getOwner()).append("\n");
        }
        if (f.getGroup() != null) {
            sb.append("Owner gid: ").append(f.getGroup()).append("\n");
        }
        if (f.getFilePermissions() != null) {
            sb.append("UNIX permissions: ").append(f.getFilePermissions()).append("\n");
        }
        if (f.getPermissions() != null) {
            String r = f.getPermissions().getReadable() ? "r" : "-";
            String w = f.getPermissions().getWritable() ? "w" : "-";
            String x = f.getPermissions().getExecutable() ? "x" : "-";
            sb.append("Current user permissions: ").append(r).append(w).append(x).append("\n");
        }
        if (lastMod != null) {
            sb.append("Last modification: ").append(lastModification).append("\n");
        }
        if (f.getExtraInformation() != null) {
            sb.append("Extra information: ").append(f.getExtraInformation()).append("\n");
        }
        if (!f.getIsDirectory() && showMetadata && f.getMetadata() != null) {
            JSONObject o = JSONUtil.asJSON(MetadataClient.asMap((MetadataType)f.getMetadata()));
            try {
                sb.append("Metadata: ").append(o.toString(2));
            }
            catch (JSONException e) {
                this.error("Can't print metadata", e);
            }
        }
        if (f.getACL() != null && f.getACL().getEntryArray() != null) {
            ACLEntryType[] acl = f.getACL().getEntryArray();
            if (acl.length > 0) {
                sb.append("ACL:\n");
            }
            for (ACLEntryType ace : acl) {
                sb.append("  ").append(this.formatACE(ace)).append("\n");
            }
        }
        return sb.toString();
    }

    private String formatACE(ACLEntryType ace) {
        StringBuilder sb = new StringBuilder();
        if (ace.isSetDefaultACL() && ace.getDefaultACL()) {
            sb.append("default:");
        }
        if (ace.getType().equals(ACLEntryTypeType.USER)) {
            sb.append("user:");
        } else {
            sb.append("group:");
        }
        if (ace.getSubject() != null) {
            sb.append(ace.getSubject());
        }
        sb.append(":");
        sb.append(ace.getPermissions());
        return sb.toString();
    }
}

