/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.actions;

import de.fzj.unicore.uas.client.HttpBasicClient;
import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.uas.fts.ProgressListener;
import de.fzj.unicore.ucc.MessageWriter;
import de.fzj.unicore.ucc.UCCOptions;
import de.fzj.unicore.ucc.actions.FileOperation;
import de.fzj.unicore.ucc.actions.Resolve;
import de.fzj.unicore.ucc.helpers.Location;
import de.fzj.unicore.ucc.util.FileDownloader;
import de.fzj.unicore.ucc.util.Mode;
import de.fzj.unicore.ucc.util.ProgressBar;
import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.client.IRegistryQuery;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.commons.cli.OptionBuilder;
import org.unigrids.services.atomic.types.ProtocolType;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class GetFile
extends FileOperation {
    protected Location sourceDesc;
    protected StorageClient sms;
    protected boolean append;
    protected boolean recurse;

    @Override
    protected void createOptions() {
        super.createOptions();
        UCCOptions uCCOptions = this.getOptions();
        OptionBuilder.withLongOpt((String)"append");
        OptionBuilder.withDescription((String)"Append to (existing) file(s)");
        OptionBuilder.isRequired((boolean)false);
        uCCOptions.addOption(OptionBuilder.create((String)"a"));
        UCCOptions uCCOptions2 = this.getOptions();
        OptionBuilder.withLongOpt((String)"recursive");
        OptionBuilder.withDescription((String)"Recurse into subdirectories");
        OptionBuilder.isRequired((boolean)false);
        uCCOptions2.addOption(OptionBuilder.create((String)"R"));
    }

    @Override
    public void process() {
        super.process();
        this.sourceDesc = this.resolve(this.source, this.registry, this.securityProperties, this);
        this.append = this.getBooleanOption("append", "a");
        this.verbose("Appending data=" + this.append);
        this.recurse = this.getBooleanOption("recursive", "R");
        if (this.recurse) {
            this.verbose("Recurse into subdirectories=" + this.recurse);
        }
        try {
            if (this.sourceDesc.isRaw()) {
                this.verbose("Source file URL " + this.sourceDesc.getSmsEpr());
                this.runRawTransfer();
            } else {
                this.verbose("Source file URL " + this.sourceDesc.getUnicore6URI());
                this.runFileDownloader();
            }
        }
        catch (Exception e) {
            this.error("Can't get file.", e);
            this.endProcessing(1);
        }
    }

    protected Location resolve(String uri, IRegistryQuery registry, IClientConfiguration sec, MessageWriter msg) {
        return Resolve.resolve(uri, registry, sec, msg);
    }

    private void runFileDownloader() throws Exception {
        EndpointReferenceType e = EndpointReferenceType.Factory.newInstance();
        e.addNewAddress().setStringValue(this.sourceDesc.getSmsEpr());
        String dn = this.findServerName(e);
        if (dn != null) {
            WSUtilities.addServerIdentity((EndpointReferenceType)e, (String)dn);
        }
        this.sms = new StorageClient(this.sourceDesc.getSmsEpr(), e, this.securityProperties);
        this.verbose("SMS contacted, server reply: servertime=" + this.sms.getCurrentTime());
        Mode mode = this.append ? Mode.append : Mode.overwrite;
        FileDownloader exp = new FileDownloader(this.sourceDesc.getName(), this.target, mode);
        String sourceDescProtocol = this.sourceDesc.getProtocol();
        if (!"BFT".equalsIgnoreCase(sourceDescProtocol)) {
            try {
                this.preferredProtocols.add(0, ProtocolType.Enum.forString((String)sourceDescProtocol));
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        exp.setPreferredProtocols(this.preferredProtocols);
        exp.setExtraParameterSource(this.properties);
        exp.setTiming(this.timing);
        exp.setRecurse(this.recurse);
        if (this.startByte != null) {
            exp.setStartByte(this.startByte);
            exp.setEndByte(this.endByte);
        }
        exp.perform(this.sms, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runRawTransfer() throws Exception {
        String url = this.sourceDesc.getSmsEpr();
        if (url.startsWith("http")) {
            HttpBasicClient hc = new HttpBasicClient(url, this.securityProperties);
            File tFile = new File(this.target);
            FileOutputStream os = new FileOutputStream(tFile);
            try {
                ProgressBar p = new ProgressBar(tFile.getName(), -1L, this);
                hc.setProgressListener((ProgressListener)p);
                if (this.startByte != null) {
                    this.verbose("Byte range: " + this.startByte + "-" + this.endByte);
                    HttpBasicClient pReader = hc;
                    pReader.readPartial(this.startByte.longValue(), this.endByte - this.startByte, (OutputStream)os);
                } else {
                    hc.readAllData((OutputStream)os);
                }
                p.finish();
            }
            finally {
                ((OutputStream)os).close();
            }
        } else {
            throw new Exception("No protocol handler for " + url);
        }
    }

    @Override
    public String getName() {
        return "get-file";
    }

    @Override
    public String getSynopsis() {
        return "Gets a file from remote location '-s' and writes it to the local file specified by the '-t' option.";
    }

    @Override
    public String getDescription() {
        return "get remote files";
    }

    @Override
    public String getArgumentList() {
        return "";
    }

    @Override
    public String getCommandGroup() {
        return "Data management";
    }
}

