/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.actions;

import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.ucc.UCCOptions;
import de.fzj.unicore.ucc.actions.SMSOperation;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.apache.commons.cli.OptionBuilder;
import org.unigrids.services.atomic.types.GridFileType;

public class Find
extends SMSOperation {
    protected boolean detailed;
    protected boolean recurse;
    protected String base;
    protected String name;
    protected DateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    protected StorageClient sms;
    static int numLastResults;

    @Override
    public String getName() {
        return "find";
    }

    @Override
    protected void createOptions() {
        super.createOptions();
        UCCOptions uCCOptions = this.getOptions();
        OptionBuilder.withLongOpt((String)"name");
        OptionBuilder.withDescription((String)"name match");
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.hasArg();
        uCCOptions.addOption(OptionBuilder.create((String)"N"));
        UCCOptions uCCOptions2 = this.getOptions();
        OptionBuilder.withLongOpt((String)"long");
        OptionBuilder.withDescription((String)"detailed listing");
        OptionBuilder.isRequired((boolean)false);
        uCCOptions2.addOption(OptionBuilder.create((String)"l"));
        UCCOptions uCCOptions3 = this.getOptions();
        OptionBuilder.withLongOpt((String)"recursive");
        OptionBuilder.withDescription((String)"recurse into subdirectories");
        OptionBuilder.isRequired((boolean)false);
        uCCOptions3.addOption(OptionBuilder.create((String)"R"));
    }

    @Override
    public void process() {
        super.process();
        this.detailed = this.getBooleanOption("long", "l");
        if (this.detailed) {
            this.verbose("Detailed listing.");
        }
        this.recurse = this.getBooleanOption("recursive", "R");
        if (this.recurse) {
            this.verbose("Listing subdirectories.");
        }
        this.name = this.getOption("name", "N");
        this.doProcess();
    }

    protected void doProcess() {
        numLastResults = 0;
        if (this.getCommandLine().getArgs().length < 2) {
            this.message("Please provide a base path and a storage address ");
            this.printUsage();
            this.endProcessing(2);
        }
        String address = this.getCommandLine().getArgs()[1];
        this.verbose("Using address <" + address + ">");
        this.sms = this.getStorageClient(address);
        this.base = this.getCommandLine().getArgs().length > 2 ? this.getCommandLine().getArgs()[2] : this.getPathAtStorage(address);
        this.doListing(this.base);
    }

    protected void doListing(String path) {
        try {
            GridFileType[] listing;
            for (GridFileType f : listing = this.sms.find(this.base, this.recurse, this.name, false, null, null)) {
                this.message(this.detailed ? this.detailedListing(f) : this.normalListing(f));
                ++numLastResults;
            }
        }
        catch (Exception e) {
            this.error("Error listing path: " + path, e);
            this.endProcessing(1);
        }
    }

    protected String normalListing(GridFileType f) {
        return f.getPath();
    }

    public String detailedListing(GridFileType f) {
        Calendar lastMod;
        String d;
        String r = " ";
        String w = " ";
        String x = " ";
        String string = d = f.getIsDirectory() ? "d" : "-";
        if (f.getPermissions() != null) {
            r = f.getPermissions().getReadable() ? "r" : "-";
            w = f.getPermissions().getWritable() ? "w" : "-";
            x = f.getPermissions().getExecutable() ? "x" : "-";
        }
        String lastModification = (lastMod = f.getLastModified()) != null ? this.format(lastMod) : "";
        return String.format("%1$1s%2$1s%3$1s%4$1s %5$14d %6$s %7$-30s", d, r, w, x, f.getSize(), lastModification, f.getPath());
    }

    @Override
    public String getDescription() {
        return "find files on storages";
    }

    @Override
    public String getSynopsis() {
        return "find files on storages.The storage can be given by EPR or using the unicore6:// URL notation.";
    }

    @Override
    public String getArgumentList() {
        return "<EPR or u6://...> <base>";
    }

    public String format(Calendar c) {
        return this.dateFormatter.format(c.getTime());
    }

    @Override
    public String getCommandGroup() {
        return "Data management";
    }

    static int getLastNumberOfResults() {
        return numLastResults;
    }
}

