/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.actions;

import de.fzj.unicore.ucc.StorageConstants;
import de.fzj.unicore.ucc.UCCOptions;
import de.fzj.unicore.ucc.actions.ActionBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.OptionBuilder;
import org.unigrids.services.atomic.types.ProtocolType;

public abstract class FileOperation
extends ActionBase
implements StorageConstants {
    protected String source;
    protected String target;
    protected Long startByte;
    protected Long endByte;
    protected final List<ProtocolType.Enum> preferredProtocols = new ArrayList<ProtocolType.Enum>();

    @Override
    protected void createOptions() {
        super.createOptions();
        if (this.needSourceTargetOpts()) {
            UCCOptions uCCOptions = this.getOptions();
            OptionBuilder.withLongOpt((String)"source");
            OptionBuilder.withDescription((String)"Data source");
            OptionBuilder.withArgName((String)"Source");
            OptionBuilder.hasArg();
            OptionBuilder.isRequired((boolean)true);
            uCCOptions.addOption(OptionBuilder.create((String)"s"));
            UCCOptions uCCOptions2 = this.getOptions();
            OptionBuilder.withLongOpt((String)"target");
            OptionBuilder.withDescription((String)"Data target");
            OptionBuilder.withArgName((String)"Target");
            OptionBuilder.hasArg();
            OptionBuilder.isRequired((boolean)true);
            uCCOptions2.addOption(OptionBuilder.create((String)"t"));
        }
        UCCOptions uCCOptions = this.getOptions();
        OptionBuilder.withLongOpt((String)"protocols");
        OptionBuilder.withDescription((String)"Preferred Protocols");
        OptionBuilder.withArgName((String)"ProtocolList");
        OptionBuilder.hasArgs();
        OptionBuilder.isRequired((boolean)false);
        uCCOptions.addOption(OptionBuilder.create((String)"P"));
        UCCOptions uCCOptions3 = this.getOptions();
        OptionBuilder.withLongOpt((String)"bytes");
        OptionBuilder.withDescription((String)"Byte range");
        OptionBuilder.withArgName((String)"ByteRange");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        uCCOptions3.addOption(OptionBuilder.create((String)"B"));
    }

    protected boolean needSourceTargetOpts() {
        return true;
    }

    @Override
    public void process() {
        super.process();
        this.initPreferredProtocols();
        this.source = this.getCommandLine().getOptionValue("s");
        this.target = this.getCommandLine().getOptionValue("t");
        this.initRange();
    }

    private void initPreferredProtocols() {
        String[] protocols = this.getCommandLine().getOptionValues("P");
        this.preferredProtocols.clear();
        this.preferredProtocols.addAll(FileOperation.getPreferredProtocols(protocols, this.properties));
        this.verbose("Using preferred protocols: " + this.preferredProtocols);
    }

    public static List<ProtocolType.Enum> getPreferredProtocols(String[] protocols, Properties properties) throws IllegalArgumentException {
        ArrayList<ProtocolType.Enum> result = new ArrayList<ProtocolType.Enum>();
        if (protocols == null || protocols.length == 0) {
            if (properties != null) {
                String protoP = properties.getProperty("protocols", "BFT");
                protocols = protoP.split(" +");
            }
            if (protocols == null || protocols.length == 0) {
                protocols = new String[]{"BFT"};
            }
        }
        for (String p : protocols) {
            if (p == null) continue;
            ProtocolType.Enum x = ProtocolType.Enum.forString((String)p);
            if (x != null) {
                result.add(x);
                continue;
            }
            throw new IllegalArgumentException("'" + p + "' does not denote a valid protocol.");
        }
        if (!result.contains(ProtocolType.BFT)) {
            result.add(ProtocolType.BFT);
        }
        return result;
    }

    protected void initRange() {
        String bytes = this.getOption("bytes", "B");
        if (bytes == null) {
            return;
        }
        String[] tokens = bytes.split("-");
        try {
            String start = tokens[0];
            String end = tokens[1];
            if (start.length() > 0) {
                this.startByte = Long.parseLong(start);
                this.endByte = Long.MAX_VALUE;
            }
            if (end.length() > 0) {
                this.endByte = Long.parseLong(end);
                if (this.startByte == null) {
                    this.startByte = 0L;
                }
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not parse byte range " + bytes);
        }
    }
}

