/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.actions;

import de.fzj.unicore.uas.TargetSystemFactory;
import de.fzj.unicore.uas.client.TSFClient;
import de.fzj.unicore.uas.client.TSSClient;
import de.fzj.unicore.ucc.IServiceInfoProvider;
import de.fzj.unicore.ucc.UCCOptions;
import de.fzj.unicore.ucc.actions.ActionBase;
import de.fzj.unicore.ucc.helpers.TargetSystemFactoryLister;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.util.Calendar;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.cli.OptionBuilder;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.OperatingSystemType;
import org.unigrids.services.atomic.types.TextInfoType;
import org.unigrids.x2006.x04.services.tsf.CreateTSRDocument;
import org.unigrids.x2006.x04.services.tsf.TargetSystemDescriptionType;
import org.unigrids.x2006.x04.services.tsf.TargetSystemFactoryPropertiesDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class CreateTSS
extends ActionBase
implements IServiceInfoProvider {
    private int initialLifeTime;
    private String factoryURL;
    private String siteName;
    private static String lastTargetSystemAddress;
    private static CreateTSRDocument lastCreateTSRDoc;

    @Override
    protected void createOptions() {
        super.createOptions();
        UCCOptions uCCOptions = this.getOptions();
        OptionBuilder.withLongOpt((String)"lifetime");
        OptionBuilder.withDescription((String)"Initial lifetime (in days) for created target systems.");
        OptionBuilder.withArgName((String)"Lifetime");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        uCCOptions.addOption(OptionBuilder.create((String)"l"));
        UCCOptions uCCOptions2 = this.getOptions();
        OptionBuilder.withLongOpt((String)"sitename");
        OptionBuilder.withDescription((String)"Name of the site");
        OptionBuilder.withArgName((String)"Site");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        uCCOptions2.addOption(OptionBuilder.create((String)"s"));
        UCCOptions uCCOptions3 = this.getOptions();
        OptionBuilder.withLongOpt((String)"factoryURL");
        OptionBuilder.withDescription((String)"Factory URL");
        OptionBuilder.withArgName((String)"Factory");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        uCCOptions3.addOption(OptionBuilder.create((String)"f"));
    }

    @Override
    public String getName() {
        return "create-tss";
    }

    @Override
    public String getArgumentList() {
        return "[param1=value1,...]";
    }

    @Override
    public String getSynopsis() {
        return "Creates a target system service instance. The TargetSystemFactory to be used can be specified. Optionally, additional parameters can be given.";
    }

    @Override
    public String getDescription() {
        return "create a target system service instance";
    }

    @Override
    public void process() {
        super.process();
        this.initialLifeTime = this.getNumericOption("lifetime", "l", -1);
        if (this.initialLifeTime > 0) {
            this.verbose("New TSSs will have a lifetime of <" + this.initialLifeTime + "> days.");
        } else {
            this.verbose("Using site default for TSS lifetime.");
        }
        this.factoryURL = this.getOption("factoryURL", "f");
        TSFClient tsf = null;
        if (this.factoryURL == null) {
            this.siteName = this.getOption("sitename", "s");
            if (this.siteName != null) {
                this.verbose("Looking for factory at site <" + this.siteName + ">");
            } else {
                this.verbose("No factory specified, will choose one from registry.");
            }
        } else {
            this.verbose("Requiring factory at <" + this.factoryURL + ">");
        }
        TargetSystemFactoryLister tsfl = new TargetSystemFactoryLister(this.registry, this.securityProperties, new Filter(), this);
        List<TSFClient> list = tsfl.list();
        if (list.size() > 0) {
            tsf = list.get(0);
            this.factoryURL = tsf.getUrl();
            this.verbose("Using factory at <" + this.factoryURL + ">");
        }
        if (tsf == null) {
            this.error("No suitable target system factory available!", null);
            this.endProcessing(1);
        }
        try {
            TSSClient tss = tsf.createTSS(this.getCreateTSRDocument());
            String addr = tss.getEPR().getAddress().getStringValue();
            this.message(addr);
            CreateTSS.setLastTSSAddress(addr);
        }
        catch (Exception ex) {
            this.error("Could not create storage", ex);
            this.endProcessing(1);
        }
    }

    protected CreateTSRDocument getCreateTSRDocument() {
        CreateTSRDocument in = CreateTSRDocument.Factory.newInstance();
        in.addNewCreateTSR();
        if (this.initialLifeTime > 0) {
            in.getCreateTSR().addNewTerminationTime().setCalendarValue(this.getTermTime());
        }
        if (this.getCommandLine().getArgs().length > 1) {
            TargetSystemDescriptionType desc = in.getCreateTSR().addNewTargetSystemDescription();
            for (int i = 1; i < this.getCommandLine().getArgs().length; ++i) {
                String arg = this.getCommandLine().getArgs()[i];
                String[] sp = arg.split("=", 2);
                TextInfoType prop = desc.addNewTextInfo();
                prop.setName(sp[0]);
                prop.setValue(sp[1]);
                this.verbose("Have parameter : " + arg);
            }
            lastCreateTSRDoc = in;
        }
        return in;
    }

    protected Calendar getTermTime() {
        Calendar c = Calendar.getInstance();
        c.add(5, this.initialLifeTime);
        return c;
    }

    @Override
    public String getCommandGroup() {
        return "General";
    }

    @Override
    public QName getQName() {
        return TargetSystemFactory.TSF_PORT;
    }

    @Override
    public String getServiceName() {
        return "TargetSystemFactory";
    }

    @Override
    public String getServiceDetails(EndpointReferenceType epr, IClientConfiguration securityProperties) {
        try {
            TSFClient tsf = new TSFClient(epr.getAddress().getStringValue(), epr, securityProperties);
            StringBuilder sb = new StringBuilder();
            String name = tsf.getResourcePropertiesDocument().getTargetSystemFactoryProperties().getName();
            sb.append(name).append(": ");
            try {
                int cpus = this.getTotalCPUs(tsf.getResourcePropertiesDocument());
                if (cpus > 0) {
                    sb.append(cpus).append(" CPUs");
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                OperatingSystemType[] os = tsf.getOperatingSystems();
                if (os.length > 0) {
                    sb.append(" ( ");
                }
                for (OperatingSystemType o : os) {
                    sb.append(o.getOperatingSystemType().getOperatingSystemName().toString()).append(" ");
                }
                if (os.length > 0) {
                    sb.append(")");
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            return sb.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private int getTotalCPUs(TargetSystemFactoryPropertiesDocument rpDoc) {
        int cpus = -1;
        if (rpDoc.getTargetSystemFactoryProperties().getTotalCPUCount() != null) {
            cpus = (int)rpDoc.getTargetSystemFactoryProperties().getTotalCPUCount().getRangeArray()[0].getUpperBound().getDoubleValue();
        } else if (rpDoc.getTargetSystemFactoryProperties().getIndividualCPUCount() != null) {
            cpus = (int)rpDoc.getTargetSystemFactoryProperties().getIndividualCPUCount().getRangeArray()[0].getUpperBound().getDoubleValue();
            if (rpDoc.getTargetSystemFactoryProperties().getTotalResourceCount() != null) {
                int nodes = (int)rpDoc.getTargetSystemFactoryProperties().getTotalResourceCount().getRangeArray()[0].getUpperBound().getDoubleValue();
                cpus *= nodes;
            }
        }
        return cpus;
    }

    public static String getLastTargetSystemAddress() {
        return lastTargetSystemAddress;
    }

    static CreateTSRDocument getLastCreateTSRDoc() {
        return lastCreateTSRDoc;
    }

    protected static void setLastTSSAddress(String lastAddress) {
        lastTargetSystemAddress = lastAddress;
    }

    private class Filter
    implements TargetSystemFactoryLister.TSFFilter {
        private Filter() {
        }

        @Override
        public boolean accept(EndpointReferenceType epr) {
            if (CreateTSS.this.factoryURL == null) {
                return true;
            }
            return epr.getAddress().getStringValue().equalsIgnoreCase(CreateTSS.this.factoryURL);
        }

        @Override
        public boolean accept(TSFClient smf) {
            return this.checkName(smf);
        }

        private boolean checkName(TSFClient smf) {
            if (CreateTSS.this.siteName == null) {
                return true;
            }
            String url = smf.getEPR().getAddress().getStringValue();
            return url.contains("/" + CreateTSS.this.siteName + "/");
        }
    }
}

