/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.actions;

import de.fzj.unicore.uas.StorageFactory;
import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.uas.client.StorageFactoryClient;
import de.fzj.unicore.ucc.IServiceInfoProvider;
import de.fzj.unicore.ucc.UCCOptions;
import de.fzj.unicore.ucc.actions.ActionBase;
import de.fzj.unicore.ucc.helpers.StorageFactoryLister;
import de.fzj.unicore.ucc.util.UnitParser;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.util.Calendar;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.cli.OptionBuilder;
import org.unigrids.services.atomic.types.PropertyType;
import org.unigrids.x2006.x04.services.smf.CreateSMSDocument;
import org.unigrids.x2006.x04.services.smf.StorageBackendParametersDocument;
import org.unigrids.x2006.x04.services.smf.StorageDescriptionType;
import org.unigrids.x2006.x04.services.smf.StorageFactoryPropertiesDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class CreateStorage
extends ActionBase
implements IServiceInfoProvider {
    private int initialLifeTime;
    private String factoryURL;
    private String siteName;
    private String storageType;
    public static final String OPT_TYPE_LONG = "type";
    public static final String OPT_TYPE = "t";
    private UnitParser units = UnitParser.getCapacitiesParser(2);
    private static String lastStorageAddress;

    @Override
    protected void createOptions() {
        super.createOptions();
        UCCOptions uCCOptions = this.getOptions();
        OptionBuilder.withLongOpt((String)"lifetime");
        OptionBuilder.withDescription((String)"Initial lifetime (in days) for created storages.");
        OptionBuilder.withArgName((String)"Lifetime");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        uCCOptions.addOption(OptionBuilder.create((String)"l"));
        UCCOptions uCCOptions2 = this.getOptions();
        OptionBuilder.withLongOpt((String)"sitename");
        OptionBuilder.withDescription((String)"Name of the site");
        OptionBuilder.withArgName((String)"Site");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        uCCOptions2.addOption(OptionBuilder.create((String)"s"));
        UCCOptions uCCOptions3 = this.getOptions();
        OptionBuilder.withLongOpt((String)"factoryURL");
        OptionBuilder.withDescription((String)"Factory URL");
        OptionBuilder.withArgName((String)"Factory");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        uCCOptions3.addOption(OptionBuilder.create((String)"f"));
        UCCOptions uCCOptions4 = this.getOptions();
        OptionBuilder.withLongOpt((String)OPT_TYPE_LONG);
        OptionBuilder.withDescription((String)"Storage type");
        OptionBuilder.withArgName((String)"Type");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        uCCOptions4.addOption(OptionBuilder.create((String)OPT_TYPE));
    }

    @Override
    public String getName() {
        return "create-storage";
    }

    @Override
    public String getArgumentList() {
        return "[param1=value1,...]";
    }

    @Override
    public String getSynopsis() {
        return "Creates a storage service instance. The StorageFactory to be used can be specified. Optionally, the type of storage plus any additional parameters can be given.";
    }

    @Override
    public String getDescription() {
        return "create a storage service instance";
    }

    @Override
    public void process() {
        StorageFactoryLister sfl;
        List<StorageFactoryClient> list;
        super.process();
        this.initialLifeTime = this.getNumericOption("lifetime", "l", -1);
        if (this.initialLifeTime > 0) {
            this.verbose("New SMSs will have a lifetime of <" + this.initialLifeTime + "> days.");
        } else {
            this.verbose("Using site default for SMS lifetime.");
        }
        this.storageType = this.getOption(OPT_TYPE_LONG, OPT_TYPE);
        this.factoryURL = this.getOption("factoryURL", "f");
        StorageFactoryClient sfc = null;
        if (this.factoryURL == null) {
            this.siteName = this.getOption("sitename", "s");
            if (this.siteName != null) {
                this.verbose("Looking for factory at site <" + this.siteName + ">");
            } else {
                this.verbose("No factory specified, will choose one from registry.");
            }
        }
        if ((list = (sfl = new StorageFactoryLister(this.registry, this.securityProperties, this, new Filter())).list()).size() > 0) {
            sfc = list.get(0);
            this.factoryURL = sfc.getUrl();
            this.verbose("Using factory at <" + this.factoryURL + ">");
        }
        if (sfc == null) {
            this.error("No suitable storage factory available!", null);
            this.endProcessing(1);
        }
        try {
            StorageClient sc = sfc.createSMS(this.getCreateSMSDocument());
            String addr = sc.getEPR().getAddress().getStringValue();
            this.message(addr);
            CreateStorage.setLastStorageAddress(addr);
        }
        catch (Exception ex) {
            this.error("Could not create storage", ex);
            this.endProcessing(1);
        }
    }

    protected CreateSMSDocument getCreateSMSDocument() {
        CreateSMSDocument in = CreateSMSDocument.Factory.newInstance();
        in.addNewCreateSMS();
        if (this.initialLifeTime > 0) {
            in.getCreateSMS().addNewTerminationTime().setCalendarValue(this.getTermTime());
        }
        if (this.storageType != null) {
            this.verbose("Will create storage of type : " + this.storageType);
            StorageDescriptionType desc = in.getCreateSMS().addNewStorageDescription();
            desc.setStorageBackendType(this.storageType);
            if (this.getCommandLine().getArgs().length > 1) {
                StorageBackendParametersDocument.StorageBackendParameters params = desc.addNewStorageBackendParameters();
                for (int i = 1; i < this.getCommandLine().getArgs().length; ++i) {
                    String arg = this.getCommandLine().getArgs()[i];
                    String[] sp = arg.split("=", 2);
                    PropertyType prop = params.addNewProperty();
                    prop.setName(sp[0]);
                    prop.setValue(sp[1]);
                    this.verbose("Have parameter : " + arg);
                }
            }
        }
        return in;
    }

    protected Calendar getTermTime() {
        Calendar c = Calendar.getInstance();
        c.add(5, this.initialLifeTime);
        return c;
    }

    @Override
    public String getCommandGroup() {
        return "General";
    }

    @Override
    public QName getQName() {
        return StorageFactory.SMF_PORT;
    }

    @Override
    public String getServiceName() {
        return "StorageFactory";
    }

    @Override
    public String getServiceDetails(EndpointReferenceType epr, IClientConfiguration securityProperties) {
        try {
            StorageFactoryClient smf = new StorageFactoryClient(epr.getAddress().getStringValue(), epr, securityProperties);
            StorageFactoryPropertiesDocument.StorageFactoryProperties pr = smf.getResourcePropertiesDocument().getStorageFactoryProperties();
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (StorageDescriptionType desc : pr.getStorageDescriptionArray()) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(this.getBriefDescription(desc));
                first = false;
            }
            return sb.toString();
        }
        catch (Exception ex) {
            return "N/A [" + CreateStorage.getDetailMessage(ex) + "]";
        }
    }

    protected String getBriefDescription(StorageDescriptionType desc) {
        StringBuilder sb = new StringBuilder();
        sb.append(desc.getStorageBackendType());
        try {
            double free = desc.getFileSystem().getDiskSpace().getExactArray()[0].getDoubleValue();
            sb.append(": ").append(this.units.getHumanReadable(free)).append(" av.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }

    public static String getLastStorageAddress() {
        return lastStorageAddress;
    }

    protected static void setLastStorageAddress(String lastAddress) {
        lastStorageAddress = lastAddress;
    }

    private class Filter
    implements StorageFactoryLister.StorageFactoryFilter {
        private Filter() {
        }

        @Override
        public boolean accept(EndpointReferenceType epr) {
            if (CreateStorage.this.factoryURL == null) {
                return true;
            }
            return epr.getAddress().getStringValue().equalsIgnoreCase(CreateStorage.this.factoryURL);
        }

        @Override
        public boolean accept(StorageFactoryClient smf) {
            return this.checkName(smf) && this.checkStorageType(smf);
        }

        private boolean checkName(StorageFactoryClient smf) {
            if (CreateStorage.this.siteName == null) {
                return true;
            }
            String url = smf.getEPR().getAddress().getStringValue();
            return url.contains("/" + CreateStorage.this.siteName + "/");
        }

        private boolean checkStorageType(StorageFactoryClient smf) {
            try {
                StorageDescriptionType[] desc;
                if (CreateStorage.this.storageType == null) {
                    return true;
                }
                for (StorageDescriptionType d : desc = smf.getResourcePropertiesDocument().getStorageFactoryProperties().getStorageDescriptionArray()) {
                    if (!CreateStorage.this.storageType.equals(d.getStorageBackendType())) continue;
                    return true;
                }
            }
            catch (Exception ex) {
                CreateStorage.this.error("Error checking factory at <" + smf.getUrl() + ">", ex);
            }
            return false;
        }
    }
}

