/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.actions;

import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.uas.client.TransferControllerClient;
import de.fzj.unicore.ucc.actions.ActionBase;
import de.fzj.unicore.ucc.helpers.Location;
import de.fzj.unicore.ucc.util.UnitParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class CopyFileStatus
extends ActionBase {
    protected Location sourceDesc;
    protected Location targetDesc;
    protected TransferControllerClient tcc;
    protected StorageClient sms;
    protected boolean synchronous;
    protected UnitParser up;

    @Override
    protected void createOptions() {
        super.createOptions();
    }

    @Override
    public void process() {
        super.process();
        try {
            this.up = UnitParser.getCapacitiesParser(3);
            this.initTCC();
            this.verbose("Transfer Resource " + this.tcc.getEPR().getAddress().getStringValue() + " contacted, reply: servertime=" + this.tcc.getCurrentTime());
            this.doCheck();
        }
        catch (Exception e) {
            this.error("Can't copy file.", e);
            this.endProcessing(1);
        }
    }

    protected void initTCC() throws Exception {
        String arg = null;
        if (this.getCommandLine().getArgs().length > 0) {
            arg = this.getCommandLine().getArgs()[1];
        }
        EndpointReferenceType epr = null;
        if (arg == null) {
            try {
                String url = new BufferedReader(new InputStreamReader(System.in)).readLine();
                epr = EndpointReferenceType.Factory.newInstance();
                epr.addNewAddress().setStringValue(url);
            }
            catch (Exception e) {
                System.err.println("Can't read file transfer descriptor from stdin.");
                this.endProcessing();
            }
        } else if (new File(arg).exists()) {
            epr = EndpointReferenceType.Factory.parse((File)new File(arg));
        } else {
            epr = EndpointReferenceType.Factory.newInstance();
            epr.addNewAddress().setStringValue(arg);
        }
        this.tcc = new TransferControllerClient(epr.getAddress().getStringValue(), epr, this.securityProperties);
    }

    protected void doCheck() throws Exception {
        long size = 0L;
        long transferred = -1L;
        size = this.tcc.getSize();
        transferred = this.tcc.getTransferredBytes();
        String status = this.tcc.getStatus();
        this.message(status + ", [" + this.up.getHumanReadable(transferred) + " / " + this.up.getHumanReadable(size) + "] bytes transferred");
    }

    @Override
    public String getName() {
        return "copy-file-status";
    }

    @Override
    public String getSynopsis() {
        return "Checks the status of a copy-file operation.";
    }

    @Override
    public String getDescription() {
        return "check status of a copy-file";
    }

    @Override
    public String getArgumentList() {
        return "[IdFile|Address]";
    }

    @Override
    public String getCommandGroup() {
        return "Data management";
    }
}

