/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.actions;

import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.uas.client.TransferControllerClient;
import de.fzj.unicore.ucc.UCCOptions;
import de.fzj.unicore.ucc.actions.FileOperation;
import de.fzj.unicore.ucc.helpers.Location;
import de.fzj.unicore.ucc.util.ProgressBar;
import de.fzj.unicore.ucc.util.UnitParser;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import java.io.File;
import java.io.FileWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.cli.OptionBuilder;
import org.unigrids.services.atomic.types.ProtocolType;
import org.unigrids.x2006.x04.services.fts.SummaryType;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class CopyFile
extends FileOperation {
    protected Location sourceDesc;
    protected Location targetDesc;
    protected TransferControllerClient tcc;
    protected StorageClient sms;
    protected boolean synchronous;
    protected long remoteSize = -1L;
    protected boolean forceRemoteCopy = false;
    protected boolean reliable = false;
    protected String scheduled = null;
    public static final String OPT_RELIABLE_LONG = "reliable";
    public static final String OPT_RELIABLE = "R";
    private static String lastFTAddress;

    @Override
    protected void createOptions() {
        super.createOptions();
        UCCOptions uCCOptions = this.getOptions();
        OptionBuilder.withLongOpt((String)"asynchronous");
        OptionBuilder.withDescription((String)"Asynchronous mode, writes the transfer ID to a file.");
        OptionBuilder.isRequired((boolean)false);
        uCCOptions.addOption(OptionBuilder.create((String)"a"));
        UCCOptions uCCOptions2 = this.getOptions();
        OptionBuilder.withLongOpt((String)"force-remote");
        OptionBuilder.withDescription((String)"Always copy remotely even if files are on the same storage");
        OptionBuilder.isRequired((boolean)false);
        uCCOptions2.addOption(OptionBuilder.create((String)"f"));
        UCCOptions uCCOptions3 = this.getOptions();
        OptionBuilder.withLongOpt((String)"schedule");
        OptionBuilder.withDescription((String)"Schedule the transfer for a specific time (in ISO8601 format)");
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.hasArg();
        uCCOptions3.addOption(OptionBuilder.create((String)"S"));
        UCCOptions uCCOptions4 = this.getOptions();
        OptionBuilder.withLongOpt((String)OPT_RELIABLE_LONG);
        OptionBuilder.withDescription((String)"Enable server-side reliable transfer mode");
        OptionBuilder.isRequired((boolean)false);
        uCCOptions4.addOption(OptionBuilder.create((String)OPT_RELIABLE));
    }

    @Override
    public void process() {
        super.process();
        lastFTAddress = null;
        this.synchronous = !this.getBooleanOption("asynchronous", "a");
        this.verbose("Synchronous transfer = " + this.synchronous);
        this.forceRemoteCopy = this.getBooleanOption("force-remote", "f");
        this.verbose("Always copying remotely = " + this.forceRemoteCopy);
        this.scheduled = this.getOption("schedule", "S");
        if (this.scheduled != null) {
            this.scheduled = UnitParser.convertDateToISO8601(this.scheduled);
            this.verbose("Will schedule transfer for " + this.scheduled);
        }
        this.reliable = this.getBooleanOption(OPT_RELIABLE_LONG, OPT_RELIABLE);
        if (this.reliable) {
            this.verbose("Will request reliable mode");
        }
        this.setOutputLocation();
        this.sourceDesc = new Location(this.source, this.registry, this.securityProperties, this);
        this.targetDesc = new Location(this.target, this.registry, this.securityProperties, this);
        EndpointReferenceType targetEPR = EndpointReferenceType.Factory.newInstance();
        targetEPR.addNewAddress().setStringValue(this.targetDesc.getSmsEpr());
        try {
            String dn = this.findServerName(targetEPR);
            if (dn != null) {
                this.securityProperties.getETDSettings().setReceiver(new X500Principal(dn));
                this.verbose("Delegating to " + dn);
            }
            this.sms = new StorageClient(this.targetDesc.getSmsEpr(), targetEPR, this.securityProperties);
            this.verbose("SMS " + this.targetDesc.getSmsEpr() + " contacted, server reply: servertime=" + this.sms.getCurrentTime());
            if (this.timing) {
                this.startTime = System.currentTimeMillis();
            }
        }
        catch (Exception ex) {
            this.error("Can't setup copy-file.", ex);
            this.endProcessing(1);
        }
        if (!this.forceRemoteCopy && this.sourceDesc.getSmsEpr().equalsIgnoreCase(this.targetDesc.getSmsEpr())) {
            this.smsCopyFile();
        } else {
            this.copyFile();
        }
        if (this.timing) {
            this.endTime = System.currentTimeMillis();
            long duration = this.endTime - this.startTime;
            double rate = (double)this.remoteSize / (double)duration;
            this.message("Rate: " + this.numberFormat.format(rate) + " kB/sec.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyFile() {
        try {
            String ftAddress;
            this.checkProtocols();
            this.verbose("Initiating FetchFile on SMS=<" + this.sms.getEPR().getAddress().getStringValue() + ">," + "receiving file <" + this.source + ">, writing to " + this.targetDesc.getName());
            this.tcc = this.sms.fetchFile(this.sourceDesc.getUnicore6URI(), this.targetDesc.getName(), this.getExtraParams(), this.reliable);
            lastFTAddress = ftAddress = this.tcc.getEPR().getAddress().getStringValue();
            this.verbose("Have filetransfer instance: " + ftAddress);
            if (!this.synchronous) {
                this.writeIDFile();
                return;
            }
            this.waitForCompletion();
        }
        catch (BaseFault f) {
            this.error("Can't copy file.", f);
            this.endProcessing(3);
        }
        catch (Exception e) {
            this.error("Can't copy file.", e);
            this.endProcessing(2);
        }
        finally {
            if (this.synchronous) {
                try {
                    this.tcc.destroy();
                }
                catch (Exception e1) {
                    this.error("Could not destroy the filetransfer client", e1);
                }
            }
        }
    }

    protected Map<String, String> getExtraParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        if (this.scheduled != null) {
            params.put("scheduledStartTime", this.scheduled);
        }
        return params;
    }

    protected void waitForCompletion() throws Exception {
        long transferred = -1L;
        this.remoteSize = this.tcc.getSize();
        ProgressBar p = new ProgressBar(this.sourceDesc.getName(), this.remoteSize, this);
        this.tcc.setUpdateInterval(-1L);
        SummaryType.Enum status = SummaryType.UNDEFINED;
        do {
            Thread.sleep(1000L);
            this.remoteSize = this.tcc.getSize();
            transferred = this.tcc.getTransferredBytes();
            p.setSize(this.remoteSize);
            p.updateTotal(transferred);
        } while (!SummaryType.FAILED.equals(status = this.tcc.getStatusSummary()) && !this.tcc.isComplete());
        this.remoteSize = this.tcc.getSize();
        transferred = this.tcc.getTransferredBytes();
        p.finish();
        if (SummaryType.FAILED.equals(status)) {
            String desc = this.tcc.getStatus();
            throw new Exception("File transfer " + desc);
        }
    }

    protected void smsCopyFile() {
        try {
            this.verbose("Copy on remote storage: " + this.sourceDesc.getName() + "->" + this.targetDesc.getName());
            this.sms.copy(this.sourceDesc.getName(), this.targetDesc.getName());
        }
        catch (BaseFault f) {
            this.error("Can't copy file.", f);
            this.endProcessing(3);
        }
        catch (Exception e) {
            this.error("Can't copy file.", e);
            this.endProcessing(2);
        }
    }

    @Override
    public String getName() {
        return "copy-file";
    }

    @Override
    public String getSynopsis() {
        return "Copies a file from a remote location '-s' and writes it to the remote storage specified by the '-t' option.";
    }

    @Override
    public String getDescription() {
        return "copy remote files";
    }

    @Override
    public String getArgumentList() {
        return "";
    }

    protected void writeIDFile() {
        try {
            File dump = new File(this.output, WSUtilities.extractResourceID((EndpointReferenceType)this.tcc.getEPR()) + ".transfer");
            FileWriter fw = new FileWriter(dump);
            fw.append(this.tcc.getEPR().toString() + "\n");
            fw.close();
            this.verbose("Wrote transfer descriptor to " + dump.getAbsolutePath());
            this.message(dump.getAbsolutePath());
        }
        catch (Exception e) {
            this.error("Could not write job ID file.", e);
        }
    }

    protected void checkProtocols() throws Exception {
        if (this.preferredProtocols.size() > 1) {
            for (ProtocolType.Enum p : this.preferredProtocols) {
                if (!Arrays.asList(this.sms.getSupportedProtocols()).contains(p)) continue;
                this.sourceDesc.setProtocol(p.toString());
                this.verbose("Using preferred protocol: " + p);
                break;
            }
        }
    }

    @Override
    public String getCommandGroup() {
        return "Data management";
    }

    static String getLastFTAddress() {
        return lastFTAddress;
    }
}

