/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.actions;

import de.fzj.unicore.ucc.Command;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jline.ConsoleReader;

public class ConnectToTestGrid
extends Command {
    private String testGridURL = "http://omiiei.zam.kfa-juelich.de/cgi-bin/unicore6/run.pl";
    private String registryURL = "https://omiiei.zam.kfa-juelich.de:6000/Registry/services/Registry?res=default_registry";
    private String[] requestParamNames = new String[]{"CN", "E", "C"};
    private String[] requestParamDesc = new String[]{"Your name", "Your email address", "2-letter country code (e.g. 'US')"};
    final Map<String, String> requestParameters = new HashMap<String, String>();
    KeyStore keystore;
    private String keystorePath;
    private String prefsPath;

    @Override
    public String getSynopsis() {
        return "Creates a temporary access to the public UNICORE testgrid, and downloads the necessary credentials. A UCC user preferences file will be generated automatically.Visit http://www.unicore.eu/testgrid for more information.";
    }

    @Override
    public String getDescription() {
        return "get credentials for the public testgrid";
    }

    @Override
    public String getName() {
        return "connect-to-testgrid";
    }

    @Override
    public void process() {
        super.process();
        try {
            this.message("Connecting to a UNICORE testgrid");
            this.message("==================================");
            this.message("");
            this.message("First we need to gather some data for generating the request.");
            boolean OK = false;
            while (!OK) {
                OK = this.initialiseUserData();
            }
            this.keystore = this.downloadKeystore();
            this.writeKeystore();
            this.writePreferencesFile();
            this.message("");
            this.message("Done! Keystore (password is 'unicore') and user preferences have been written to the '" + this.output + "' directory.");
            this.message("");
            this.message("You could now try:");
            this.message("ucc connect -v -c " + this.prefsPath);
        }
        catch (Exception ex) {
            this.error("", ex);
        }
    }

    protected boolean initialiseUserData() throws IOException {
        for (int i = 0; i < this.requestParamDesc.length; ++i) {
            String value = this.getLine(this.requestParamDesc[i] + ": ");
            this.requestParameters.put(this.requestParamNames[i], value);
        }
        this.message("Enter the testgrid URL. Default: " + this.testGridURL);
        String tgURL = this.getLine("URL: ");
        if (!tgURL.trim().equals("")) {
            this.testGridURL = tgURL;
        }
        return this.confirm("Thank you! Are these values OK [Y]");
    }

    protected void writeKeystore() throws IOException, CertificateException {
        File f = new File(this.output, "testgrid-keystore.jks");
        if (f.exists() && !this.confirm("Keystore file exists. Overwrite? [Y]")) {
            throw new IOException("File exists.");
        }
        try {
            this.keystore.store(new FileOutputStream(f), "unicore".toCharArray());
            this.keystorePath = f.getAbsolutePath();
        }
        catch (Exception ex) {
            throw new IOException(ex.getMessage());
        }
    }

    protected void writePreferencesFile() throws IOException {
        File f = new File(this.output, "testgrid-preferences");
        if (f.exists() && !this.confirm("Preferences file exists. Overwrite? [Y]")) {
            throw new IOException("File exists.");
        }
        PrintWriter pw = new PrintWriter(f);
        pw.println("#");
        pw.println("# UCC preferences for connecting to the public testgrid");
        pw.println("# Created: " + new Date().toString());
        pw.println("#");
        pw.println("registry=" + this.registryURL);
        pw.println("credential.path=" + this.keystorePath);
        pw.println("credential.password=unicore");
        pw.println("credential.keyPassword=unicore");
        pw.println("truststore.type=keystore");
        pw.println("truststore.keystorePath=" + this.keystorePath);
        pw.println("truststore.keystorePassword=unicore");
        pw.close();
        this.prefsPath = f.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    KeyStore downloadKeystore() throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        String jks = this.getJKSURL();
        URL u = new URL(jks);
        HttpURLConnection http = (HttpURLConnection)u.openConnection();
        InputStream is = http.getInputStream();
        try {
            KeyStore ks = KeyStore.getInstance("jks");
            ks.load(is, "unicore".toCharArray());
            KeyStore keyStore = ks;
            return keyStore;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ignored) {}
        }
    }

    String getJKSURL() throws IOException {
        this.message("Connecting to " + this.testGridURL);
        this.message("This can take some time, since a certificate is generated for you.");
        URL u = new URL(this.testGridURL);
        HttpURLConnection http = (HttpURLConnection)u.openConnection();
        http.setRequestMethod("POST");
        http.setConnectTimeout(5000);
        StringBuilder request = new StringBuilder();
        request.append("KEYSTOREONLY=").append(URLEncoder.encode("on", "UTF-8"));
        for (String p : this.requestParamNames) {
            request.append("&").append(p).append("=");
            request.append(URLEncoder.encode(this.requestParameters.get(p), "UTF-8"));
        }
        http.setDoOutput(true);
        OutputStreamWriter wr = new OutputStreamWriter(http.getOutputStream());
        wr.write(request.toString());
        wr.flush();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        int code = http.getResponseCode();
        if (code == 200) {
            int len;
            InputStream response = http.getInputStream();
            byte[] data = new byte[8192];
            while ((len = response.read(data)) != -1) {
                os.write(data, 0, len);
            }
        } else {
            throw new IOException("Can't perform request. Error : " + http.getResponseCode() + " " + http.getResponseMessage());
        }
        return this.extractURL(os.toString());
    }

    String extractURL(String source) throws IOException {
        this.verbose("Extracting URL from web site reply\n" + source);
        Pattern p = Pattern.compile(".+href=\"(.*\\.jks).*", 32);
        Matcher m = p.matcher(source);
        if (m.matches()) {
            return m.group(1);
        }
        this.error("Can't extract url from " + source, null);
        throw new IOException("Can't extract keystore URL.");
    }

    String getLine(String message) throws IOException {
        ConsoleReader r = new ConsoleReader();
        if (message != null) {
            r.printString(message);
        }
        return r.readLine(" ");
    }

    boolean confirm(String message) throws IOException {
        String line = this.getLine(message);
        return line == null || line.trim().equals("") || line.trim().equalsIgnoreCase("y");
    }
}

