/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.actions;

import de.fzj.unicore.ucc.UCCOptions;
import de.fzj.unicore.ucc.actions.ActionBase;
import de.fzj.unicore.ucc.helpers.Connector;
import org.apache.commons.cli.OptionBuilder;

public class Connect
extends ActionBase {
    private int initialLifeTime;
    private static String lastRegistryURL;

    @Override
    protected void createOptions() {
        super.createOptions();
        UCCOptions uCCOptions = this.getOptions();
        OptionBuilder.withLongOpt((String)"lifetime");
        OptionBuilder.withDescription((String)"Initial lifetime (in days) for created target systems.");
        OptionBuilder.withArgName((String)"Lifetime");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        uCCOptions.addOption(OptionBuilder.create((String)"l"));
    }

    @Override
    public String getName() {
        return "connect";
    }

    @Override
    public String getArgumentList() {
        return "";
    }

    @Override
    public String getSynopsis() {
        return "Connects to UNICORE. If not yet done, target system services are initialised.";
    }

    @Override
    public String getDescription() {
        return "connect to UNICORE";
    }

    @Override
    public void process() {
        super.process();
        lastRegistryURL = this.registryURL;
        this.initialLifeTime = this.getNumericOption("lifetime", "l", -1);
        if (this.initialLifeTime > 0) {
            this.verbose("New TSSs will have a lifetime of <" + this.initialLifeTime + "> days.");
        } else {
            this.verbose("Using site default for TSS lifetime.");
        }
        Connector c = new Connector(this.registry, this.securityProperties, this);
        String black = this.properties.getProperty("blacklist", null);
        c.setBlacklist(black);
        c.run();
        int tsfAvailable = c.getAvailableTSF();
        if (tsfAvailable == 0) {
            this.message("There are no target system factories in the selected registry.");
        }
        int tssAvailable = c.getAvailableTSS();
        this.message("You can access " + tssAvailable + " target system(s).");
        if (tssAvailable == 0) {
            this.endProcessing(1);
        }
    }

    @Override
    public String getCommandGroup() {
        return "General";
    }

    static String getLastReqistryURL() {
        return lastRegistryURL;
    }
}

