/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.actions;

import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.ucc.UCCOptions;
import de.fzj.unicore.ucc.actions.SMSOperation;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.unigrids.x2006.x04.services.sms.PermissionsChangeModeType;
import org.unigrids.x2006.x04.services.sms.PermissionsClassType;

public class Chmod
extends SMSOperation {
    public static final Pattern pattern = Pattern.compile("[r-][w-][Xx-]");

    @Override
    protected void createOptions() {
        super.createOptions();
        UCCOptions uCCOptions = this.getOptions();
        OptionBuilder.withLongOpt((String)"recursive");
        OptionBuilder.withDescription((String)"Recursively applies the operation to the whole contents of the direcotry specified as an argument.");
        OptionBuilder.isRequired((boolean)false);
        uCCOptions.addOption(OptionBuilder.create((String)"R"));
    }

    @Override
    public String getName() {
        return "chmod";
    }

    @Override
    public String getSynopsis() {
        return "Changes access permissions of a file on a remote storage.";
    }

    @Override
    public String getDescription() {
        return "change file's access permissions";
    }

    @Override
    public String getArgumentList() {
        return "<u|g|o><-|+|=><r|-><w|-><x|X|-> <[Storage-URL#]/path or [u6://SITENAME/[JobId|StorageName]]/path>";
    }

    @Override
    public String getCommandGroup() {
        return "Data management";
    }

    @Override
    public void process() {
        super.process();
        boolean recursive = this.getBooleanOption("recursive", "R");
        this.verbose("Recursive invocation = " + recursive);
        CommandLine cmdLine = this.getCommandLine();
        if (cmdLine.getArgs().length != 3) {
            this.error("Wrong number of arguments", null);
            this.printUsage();
            this.endProcessing(2);
        }
        String spec = cmdLine.getArgs()[1];
        String target = cmdLine.getArgs()[2];
        this.verbose("Setting access on " + target);
        if (spec.length() != 5) {
            this.errorPerm(spec);
        }
        char[] specC = spec.toCharArray();
        PermissionsChangeModeType.Enum mode = null;
        PermissionsClassType.Enum permClass = null;
        switch (specC[0]) {
            case 'u': {
                permClass = PermissionsClassType.USER;
                break;
            }
            case 'g': {
                permClass = PermissionsClassType.GROUP;
                break;
            }
            case 'o': {
                permClass = PermissionsClassType.OTHER;
                break;
            }
            default: {
                this.errorPerm(spec);
            }
        }
        switch (specC[1]) {
            case '-': {
                mode = PermissionsChangeModeType.SUBTRACT;
                break;
            }
            case '+': {
                mode = PermissionsChangeModeType.ADD;
                break;
            }
            case '=': {
                mode = PermissionsChangeModeType.SET;
                break;
            }
            default: {
                this.errorPerm(spec);
            }
        }
        String perms = spec.substring(2);
        if (!pattern.matcher(perms).matches()) {
            this.errorPerm(spec);
        }
        StorageClient sms = this.getStorageClient(target);
        try {
            String path = this.getPathAtStorage(target);
            sms.changePermissions2(path, mode, permClass, perms, recursive);
        }
        catch (Exception ex) {
            this.error("Can't change permissions.", ex);
            this.endProcessing(1);
        }
    }

    private void errorPerm(String perm) {
        this.error("Invalid format of permission specification: " + perm, null);
        this.printUsage();
        this.endProcessing(2);
    }
}

