/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.actions;

import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.ucc.UCCOptions;
import de.fzj.unicore.ucc.actions.SMSOperation;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;

public class Chgrp
extends SMSOperation {
    @Override
    protected void createOptions() {
        super.createOptions();
        UCCOptions uCCOptions = this.getOptions();
        OptionBuilder.withLongOpt((String)"recursive");
        OptionBuilder.withDescription((String)"Recursively applies the operation to the whole contents of the direcotry specified as an argument.");
        OptionBuilder.isRequired((boolean)false);
        uCCOptions.addOption(OptionBuilder.create((String)"R"));
    }

    @Override
    public String getName() {
        return "chgrp";
    }

    @Override
    public String getSynopsis() {
        return "Changes an owning group of a file on a remote storage.";
    }

    @Override
    public String getDescription() {
        return "change file's group";
    }

    @Override
    public String getArgumentList() {
        return "<group> <[Storage-URL#]/path or [u6://SITENAME/[JobId|StorageName]]/path>";
    }

    @Override
    public String getCommandGroup() {
        return "Data management";
    }

    @Override
    public void process() {
        super.process();
        boolean recursive = this.getBooleanOption("recursive", "R");
        this.verbose("Recursive invocation = " + recursive);
        CommandLine cmdLine = this.getCommandLine();
        if (cmdLine.getArgs().length != 3) {
            this.error("Not enough arguments", null);
            this.printUsage();
            this.endProcessing(2);
        }
        String group = cmdLine.getArgs()[1];
        String target = cmdLine.getArgs()[2];
        this.verbose("Setting group to " + group + " on " + target);
        StorageClient sms = this.getStorageClient(target);
        try {
            String path = this.getPathAtStorage(target);
            sms.chgrp(path, group, recursive);
        }
        catch (Exception ex) {
            this.error("Can't change file group.", ex);
            this.endProcessing(1);
        }
    }
}

