/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.actions;

import de.fzj.unicore.uas.client.HttpBasicClient;
import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.ucc.MessageWriter;
import de.fzj.unicore.ucc.StorageConstants;
import de.fzj.unicore.ucc.actions.FileOperation;
import de.fzj.unicore.ucc.actions.Resolve;
import de.fzj.unicore.ucc.helpers.Location;
import de.fzj.unicore.ucc.util.FileDownloader;
import de.fzj.unicore.ucc.util.Mode;
import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.client.IRegistryQuery;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.io.OutputStream;
import org.unigrids.services.atomic.types.ProtocolType;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class CatFile
extends FileOperation
implements StorageConstants {
    protected Location sourceDesc;
    protected StorageClient sms;

    @Override
    protected void createOptions() {
        super.createOptions();
    }

    @Override
    protected boolean needSourceTargetOpts() {
        return false;
    }

    @Override
    public void process() {
        super.process();
        if (this.getCommandLine().getArgs().length > 1) {
            for (int i = 1; i < this.getCommandLine().getArgs().length; ++i) {
                this.source = this.getCommandLine().getArgs()[1];
                this.sourceDesc = this.resolve(this.source, this.registry, this.securityProperties, this);
                try {
                    if (this.sourceDesc.isRaw()) {
                        this.verbose("Source file URL " + this.sourceDesc.getSmsEpr());
                        this.runRawTransfer();
                    } else {
                        this.verbose("Source file URL " + this.sourceDesc.getUnicore6URI());
                        this.runFileDownloader();
                    }
                }
                catch (Exception e) {
                    this.error("Can't get file.", e);
                    this.endProcessing(1);
                }
                System.out.println();
            }
        } else {
            this.error("Please specify a remote file!", null);
            this.endProcessing(1);
        }
    }

    protected Location resolve(String uri, IRegistryQuery registry, IClientConfiguration sec, MessageWriter msg) {
        return Resolve.resolve(uri, registry, sec, msg);
    }

    private void runFileDownloader() throws Exception {
        EndpointReferenceType e = EndpointReferenceType.Factory.newInstance();
        e.addNewAddress().setStringValue(this.sourceDesc.getSmsEpr());
        String dn = this.findServerName(e);
        if (dn != null) {
            WSUtilities.addServerIdentity((EndpointReferenceType)e, (String)dn);
        }
        this.sms = new StorageClient(this.sourceDesc.getSmsEpr(), e, this.securityProperties);
        this.verbose("SMS contacted, server reply: servertime=" + this.sms.getCurrentTime());
        FileDownloader exp = new FileDownloader(this.sourceDesc.getName(), "", Mode.overwrite);
        String sourceDescProtocol = this.sourceDesc.getProtocol();
        if (!"BFT".equalsIgnoreCase(sourceDescProtocol)) {
            try {
                this.preferredProtocols.add(0, ProtocolType.Enum.forString((String)sourceDescProtocol));
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        exp.setPreferredProtocols(this.preferredProtocols);
        exp.setExtraParameterSource(this.properties);
        exp.setTiming(this.timing);
        exp.setForceFileOnly(true);
        exp.setShowProgress(false);
        exp.setTargetStream(this.getStdout());
        if (this.startByte != null) {
            exp.setStartByte(this.startByte);
            exp.setEndByte(this.endByte);
        }
        exp.perform(this.sms, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runRawTransfer() throws Exception {
        String url = this.sourceDesc.getSmsEpr();
        if (url.startsWith("http")) {
            HttpBasicClient hc = new HttpBasicClient(url, this.securityProperties);
            OutputStream os = this.getStdout();
            try {
                if (this.startByte != null) {
                    this.verbose("Byte range: " + this.startByte + "-" + this.endByte);
                    HttpBasicClient pReader = hc;
                    pReader.readPartial(this.startByte.longValue(), this.endByte - this.startByte, os);
                }
                hc.readAllData(os);
            }
            finally {
                os.close();
            }
        } else {
            throw new Exception("No protocol handler for " + url);
        }
    }

    OutputStream getStdout() {
        return System.out;
    }

    @Override
    public String getName() {
        return "cat";
    }

    @Override
    public String getSynopsis() {
        return "Prints a file from remote location to stdout";
    }

    @Override
    public String getDescription() {
        return "cat remote files";
    }

    @Override
    public String getArgumentList() {
        return "<file_url>";
    }

    @Override
    public String getCommandGroup() {
        return "Data management";
    }
}

