/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.actions;

import de.fzj.unicore.ucc.UCCOptions;
import de.fzj.unicore.ucc.actions.ActionBase;
import de.fzj.unicore.ucc.helpers.CachingRegistryClient;
import de.fzj.unicore.ucc.helpers.ResourceCache;
import de.fzj.unicore.ucc.runner.RandomSelection;
import de.fzj.unicore.ucc.runner.RequestQueue;
import de.fzj.unicore.ucc.runner.Runner;
import de.fzj.unicore.ucc.runner.RunningQueue;
import de.fzj.unicore.ucc.runner.SiteSelectionStrategy;
import de.fzj.unicore.ucc.runner.WeightedSelection;
import de.fzj.unicore.ucc.util.Builder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.cli.OptionBuilder;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionDocument;

public class Batch
extends ActionBase {
    private boolean follow;
    private File inputDir;
    private boolean keepJobs;
    private boolean noFetchOutcome;
    private boolean submitOnly;
    private String siteName;
    private RequestQueue requests;
    private RunningQueue running;
    private int numRequests = 0;
    private SiteSelectionStrategy siteSelectionStragegy = new RandomSelection();
    public static final int DEFAULT_UPDATE = 1000;
    public static final int DEFAULT_LIMIT = 100;
    public static final int DEFAULT_REQUEST_LIMIT = 100;
    public static final int DEFAULT_THREADS = 4;
    private int updateInterval;
    private int runningJobLimit;
    private int requestLimit = 100;
    private int numThreads;
    private boolean noResourceCheck = false;
    private boolean isJSDL = false;
    private ThreadPoolExecutor executor = null;
    private final AtomicInteger activeJobs = new AtomicInteger(0);
    private final AtomicInteger activeRequests = new AtomicInteger(0);
    private volatile boolean isShutdown = false;

    @Override
    protected void createOptions() {
        super.createOptions();
        UCCOptions uCCOptions = this.getOptions();
        OptionBuilder.withLongOpt((String)"follow");
        OptionBuilder.withDescription((String)"Follow mode");
        OptionBuilder.isRequired((boolean)false);
        uCCOptions.addOption(OptionBuilder.create((String)"f"));
        UCCOptions uCCOptions2 = this.getOptions();
        OptionBuilder.withLongOpt((String)"input");
        OptionBuilder.withDescription((String)"Input directory");
        OptionBuilder.withArgName((String)"Inputdir");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        uCCOptions2.addOption(OptionBuilder.create((String)"i"));
        UCCOptions uCCOptions3 = this.getOptions();
        OptionBuilder.withLongOpt((String)"keep");
        OptionBuilder.withDescription((String)"don't remove finished jobs");
        OptionBuilder.isRequired((boolean)false);
        uCCOptions3.addOption(OptionBuilder.create((String)"K"));
        UCCOptions uCCOptions4 = this.getOptions();
        OptionBuilder.withLongOpt((String)"update");
        OptionBuilder.withDescription((String)"minimum update interval (millis)");
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"UpdateInterval");
        uCCOptions4.addOption(OptionBuilder.create((String)"u"));
        UCCOptions uCCOptions5 = this.getOptions();
        OptionBuilder.withLongOpt((String)"max");
        OptionBuilder.withDescription((String)"maximum number of jobs at a time");
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"MaxRunningJobs");
        uCCOptions5.addOption(OptionBuilder.create((String)"m"));
        UCCOptions uCCOptions6 = this.getOptions();
        OptionBuilder.withLongOpt((String)"maxNewJobs");
        OptionBuilder.withDescription((String)"maximum number of jobs submitted at a time");
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"MaxNewJobs");
        uCCOptions6.addOption(OptionBuilder.create((String)"M"));
        UCCOptions uCCOptions7 = this.getOptions();
        OptionBuilder.withLongOpt((String)"threads");
        OptionBuilder.withDescription((String)"number of concurrent client threads");
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"NumberOfThreads");
        uCCOptions7.addOption(OptionBuilder.create((String)"t"));
        UCCOptions uCCOptions8 = this.getOptions();
        OptionBuilder.withLongOpt((String)"noResourceCheck");
        OptionBuilder.withDescription((String)"do not check if required resources are available");
        OptionBuilder.isRequired((boolean)false);
        uCCOptions8.addOption(OptionBuilder.create((String)"R"));
        UCCOptions uCCOptions9 = this.getOptions();
        OptionBuilder.withLongOpt((String)"noFetchOutcome");
        OptionBuilder.withDescription((String)"Do NOT get stdout/stderr");
        OptionBuilder.isRequired((boolean)false);
        uCCOptions9.addOption(OptionBuilder.create((String)"X"));
        UCCOptions uCCOptions10 = this.getOptions();
        OptionBuilder.withLongOpt((String)"jsdl");
        OptionBuilder.withDescription((String)"Treat job files as JSDL documents");
        OptionBuilder.isRequired((boolean)false);
        uCCOptions10.addOption(OptionBuilder.create((String)"j"));
        UCCOptions uCCOptions11 = this.getOptions();
        OptionBuilder.withLongOpt((String)"sitename");
        OptionBuilder.withDescription((String)"Site Name");
        OptionBuilder.withArgName((String)"Vsite");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        uCCOptions11.addOption(OptionBuilder.create((String)"s"));
        UCCOptions uCCOptions12 = this.getOptions();
        OptionBuilder.withLongOpt((String)"siteWeights");
        OptionBuilder.withDescription((String)"file containing site weights");
        OptionBuilder.withArgName((String)"fileName");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        uCCOptions12.addOption(OptionBuilder.create((String)"W"));
        UCCOptions uCCOptions13 = this.getOptions();
        OptionBuilder.withLongOpt((String)"submitOnly");
        OptionBuilder.withDescription((String)"only submit jobs, do not wait for completion");
        OptionBuilder.isRequired((boolean)false);
        uCCOptions13.addOption(OptionBuilder.create((String)"S"));
    }

    @Override
    public String getName() {
        return "batch";
    }

    @Override
    public String getDescription() {
        return "run ucc on a set of files";
    }

    @Override
    public String getSynopsis() {
        return "Runs UCC on all job files in a given directory. In 'follow' mode, UCC will wait for new jobs and process them as they arrive.";
    }

    @Override
    public String getArgumentList() {
        return "";
    }

    @Override
    public String getCommandGroup() {
        return "Job execution";
    }

    @Override
    protected void initRegistryClient() {
        super.initRegistryClient();
        this.verbose("Creating caching registry.");
        this.registry = new CachingRegistryClient(this.registry);
    }

    @Override
    public void process() {
        String siteWeightFile;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Batch.this.doShutdown();
            }
        });
        super.process();
        String inDir = this.getCommandLine().getOptionValue("i", this.properties.getProperty("input"));
        this.inputDir = new File(inDir);
        if (!this.inputDir.exists() || !this.inputDir.isFile()) {
            try {
                this.inputDir.mkdirs();
                this.verbose("Created request directory <" + inDir + ">");
            }
            catch (Exception ex) {
                this.error("Can't access directory <" + inDir + ">.", null);
                this.endProcessing(1);
            }
        }
        this.follow = this.getBooleanOption("follow", "f");
        this.verbose("Follow mode = " + this.follow);
        this.keepJobs = this.getBooleanOption("keep", "K");
        this.verbose("Cleaning up done jobs = " + !this.keepJobs);
        this.runningJobLimit = this.getNumericOption("max", "m", 100);
        this.verbose("Limit on number of running jobs = " + this.runningJobLimit);
        this.requestLimit = this.getNumericOption("maxNewJobs", "M", 100);
        if (this.requestLimit != 100) {
            this.verbose("Limit on number of new job submissions = " + this.requestLimit);
        }
        this.updateInterval = this.getNumericOption("update", "u", 1000);
        this.verbose("Update interval = " + this.updateInterval + " ms.");
        this.numThreads = this.getNumericOption("threads", "t", 4);
        this.verbose("Number of executor threads = " + this.numThreads);
        this.noResourceCheck = this.getBooleanOption("noResourceCheck", "R");
        this.verbose("Checking available resources = " + !this.noResourceCheck);
        this.noFetchOutcome = this.getBooleanOption("noFetchOutcome", "X");
        this.verbose("Getting standard output and standard error = " + !this.noFetchOutcome);
        this.submitOnly = this.getBooleanOption("submitOnly", "S");
        if (this.submitOnly) {
            this.verbose("'Submit only' mode = " + this.submitOnly);
        }
        this.isJSDL = this.getBooleanOption("jsdl", "j");
        this.verbose("Assuming JSDL docs = " + this.isJSDL);
        this.siteName = this.getCommandLine().getOptionValue("s");
        if (this.siteName != null) {
            this.verbose("Using site = " + this.siteName);
        }
        if ((siteWeightFile = this.getCommandLine().getOptionValue("W")) != null) {
            File swf = new File(siteWeightFile);
            if (!swf.exists() || !swf.canRead()) {
                this.error("Can't read " + swf.getAbsolutePath(), null);
            } else {
                this.siteSelectionStragegy = new WeightedSelection(swf, this);
                this.verbose("Using site selection weights from " + swf.getAbsolutePath());
            }
        }
        this.executor = new ThreadPoolExecutor(this.numThreads, this.numThreads, 500L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        try {
            this.doBatch();
        }
        catch (Exception e) {
            this.error("Error executing batch command.", e);
            this.endProcessing(1);
        }
        this.doShutdown();
    }

    private void doShutdown() {
        if (this.isShutdown) {
            return;
        }
        this.isShutdown = true;
        this.message("UCC batch mode exiting.");
        while (Runner.getCounter() > 0) {
            this.message("... waiting for tasks to finish.");
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.executor.shutdown();
        this.message("Site selection summary:");
        this.message(this.printSelectionStatistics(this.siteSelectionStragegy.getSelectionStatistics()));
        this.verbose("Resource cache hits: " + ResourceCache.getInstance().getCacheHits());
    }

    protected void doBatch() throws IOException, InterruptedException {
        this.requests = new RequestQueue(this.inputDir.getAbsolutePath(), this.follow);
        this.running = new RunningQueue(this.inputDir.getAbsolutePath() + File.separator + "RUNNING_JOBS");
        this.running.setLimit(this.runningJobLimit);
        this.running.setDelay(this.updateInterval);
        this.activeJobs.set(this.running.length());
        this.verbose("Starting batch processing...");
        while (true) {
            String nextReq;
            if (this.activeJobs.get() < this.runningJobLimit && this.activeRequests.get() < this.requestLimit && (nextReq = this.requests.next()) != null) {
                this.verbose("Processing request: " + nextReq);
                ++this.numRequests;
                this.activeRequests.incrementAndGet();
                this.createRequest(nextReq);
                continue;
            }
            if (!this.submitOnly) {
                String nextRunning = this.running.next(100L, TimeUnit.MILLISECONDS);
                if (nextRunning != null) {
                    this.handleRunningJob(nextRunning);
                }
            } else {
                Thread.sleep(100L);
            }
            if (!this.follow && this.activeRequests.get() <= 0 && this.activeJobs.get() <= 0 && this.requests.length() <= 0) break;
        }
        this.executor.shutdown();
        this.verbose("Exiting, " + this.numRequests + " requests were processed.");
    }

    protected void createRequest(String nextReq) {
        try {
            Builder b;
            File f = new File(nextReq);
            if (this.isJSDL) {
                JobDefinitionDocument jdd = JobDefinitionDocument.Factory.parse((File)f);
                b = new Builder();
                b.setJob(jdd);
            } else {
                b = new Builder(f);
            }
            b.setSecurityProperties(this.securityProperties);
            b.setRegistry(this.registry);
            b.setMessageWriter(this);
            b.setProperty("source", nextReq);
            String requestName = f.getName();
            int i = requestName.lastIndexOf(46);
            if (i > 0) {
                requestName = requestName.substring(0, i);
            }
            b.setProperty("requestName", requestName);
            b.setProperty("state", "NEW");
            if (this.siteName != null) {
                b.setSite(this.siteName);
            }
            f.delete();
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    Batch.this.processRequest(b);
                }
            });
        }
        catch (Exception e) {
            this.error("", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(Builder b) {
        try {
            if (this.isShutdown) {
                return;
            }
            b.setProperty("Output", this.output.getAbsolutePath());
            b.setProperty("IDLocation", this.running.getRequestDir().getAbsolutePath());
            Runner r = new Runner(this.registry, this.securityProperties, b, this);
            r.setAsyncMode(true);
            r.setCheckResources(!this.noResourceCheck);
            r.setNoFetchOutCome(this.noFetchOutcome);
            r.setSubmitOnly(this.submitOnly);
            r.setSiteSelectionStrategy(this.siteSelectionStragegy);
            r.setProperties(this.properties);
            if (this.siteName != null) {
                r.setSiteName(this.siteName);
            }
            r.run();
            if (!this.submitOnly) {
                this.verbose("Job ID=" + r.getBuilder().getProperty("jobIdFile"));
                this.activeJobs.incrementAndGet();
            }
        }
        catch (Exception e) {
            this.error("Error processing request <" + b.getProperty("source") + ">", e);
            this.endProcessing(1);
        }
        finally {
            this.activeRequests.decrementAndGet();
        }
    }

    protected void handleRunningJob(String nextRunning) {
        try {
            if (this.isShutdown) {
                return;
            }
            File f = new File(nextRunning);
            final Builder b = new Builder(f);
            b.setSecurityProperties(this.securityProperties);
            b.setRegistry(this.registry);
            b.setMessageWriter(this);
            b.setProperty("Output", this.output.getAbsolutePath());
            b.setProperty("IDLocation", this.running.getRequestDir().getAbsolutePath());
            b.setProperty("KeepFinishedJob", "" + this.keepJobs);
            b.setProperty("source", nextRunning);
            f.delete();
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    Batch.this.processRunning(b);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void processRunning(Builder b) {
        if (this.isShutdown) {
            return;
        }
        String req = b.getProperty("source");
        try {
            logger.debug((Object)("Processing running job <" + req + ">"));
            Runner r = new Runner(this.registry, this.securityProperties, b, this);
            r.setAsyncMode(true);
            r.setCheckResources(!this.noResourceCheck);
            r.setNoFetchOutCome(this.noFetchOutcome);
            r.setProperties(this.properties);
            r.run();
            String state = r.getBuilder().getProperty("state");
            if ("FINISHED".equals(state)) {
                this.activeJobs.decrementAndGet();
            } else {
                FileWriter fw = new FileWriter(new File(req));
                b.writeTo(fw);
                fw.close();
            }
        }
        catch (Exception e) {
            this.error("Error processing running job <" + req + ">", e);
        }
    }

    public String printSelectionStatistics(Map<String, Integer> stats) {
        StringBuilder sb = new StringBuilder();
        String newline = System.getProperty("line.separator");
        sb.append(newline);
        sb.append(String.format("  %-30s|%8s", "Site name", "Jobs run"));
        sb.append(newline);
        sb.append("  ---------------------------------------");
        sb.append(newline);
        for (String site : stats.keySet()) {
            sb.append(String.format("  %-30s|%8d", site, stats.get(site)));
            sb.append(newline);
        }
        return sb.toString();
    }
}

