/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.actions;

import de.fzj.unicore.uas.util.PropertyHelper;
import de.fzj.unicore.ucc.Command;
import de.fzj.unicore.ucc.UCC;
import de.fzj.unicore.ucc.UCCOptions;
import de.fzj.unicore.ucc.authn.Authentication;
import de.fzj.unicore.ucc.helpers.AttributeAssertionFetcher;
import de.fzj.unicore.ucc.helpers.EndProcessingException;
import de.fzj.unicore.ucc.util.IRegistryFactory;
import de.fzj.unicore.ucc.util.MultiRegistryQuery;
import de.fzj.unicore.ucc.util.VOAttributeFilter;
import de.fzj.unicore.wsrflite.xfire.ClientException;
import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.client.IRegistryQuery;
import eu.unicore.samly2.assertion.Assertion;
import eu.unicore.security.etd.TrustDelegation;
import eu.unicore.security.xfireutil.client.SAMLAttributePushOutHandler;
import eu.unicore.util.httpclient.ClientProperties;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.commons.cli.OptionBuilder;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.oasisOpen.docs.wsrf.sg2.EntryType;
import org.w3.x2005.x08.addressing.EndpointReferenceType;
import xmlbeans.org.oasis.saml2.assertion.AssertionDocument;

public abstract class ActionBase
extends Command {
    protected IRegistryQuery registry;
    protected IClientConfiguration securityProperties;
    protected String registryURL;
    public static final VOAttributeFilter DEFAULT_ATTRIBUTE_FILTER = VOAttributeFilter.EMPTY_FILTER;
    public static final String PREFERENCE_ARG_VO = "vo";
    public static final String PREFERENCE_ARG_ROLE = "role";
    public static final String PREFERENCE_ARG_UID = "uid";
    public static final String PREFERENCE_ARG_PGID = "pgid";
    public static final String PREFERENCE_ARG_SUP_GIDS = "supgids";
    public static final String PREFERENCE_ARG_ADD_OS_GIDS = "useOSgids";
    public static final String PREFERENCE_ARG = "[see description]";
    public static final String PREFERENCE_ARG_HELP = "vo:<val>|role:<val>|uid:<val>|pgid:<val>|supgids:<val1,val2,...>|useOSgids:<true|false>";
    protected String attrAssertionFilename;
    protected String voURL;
    protected List<Element> rawXmlSAMLAssertions;
    protected Assertion rawSAMLAssertion;
    protected VOAttributeFilter attributeFilter;
    protected boolean useSAMLPush = false;

    @Override
    protected void createOptions() {
        super.createOptions();
        this.createGeneralOptions();
        this.createSecurityOptions();
        this.createVOOptions();
    }

    private void createSecurityOptions() {
        UCCOptions uCCOptions = this.getOptions();
        OptionBuilder.withLongOpt((String)"authenticationMethod");
        OptionBuilder.withDescription((String)"The method used for authentication (default: X509)");
        OptionBuilder.withArgName((String)"AuthenticationMethod");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        uCCOptions.addOption(OptionBuilder.create((String)"k"), "__SECURITY__");
        UCCOptions uCCOptions2 = this.getOptions();
        OptionBuilder.withLongOpt((String)"delegationAssertion");
        OptionBuilder.withDescription((String)"SAML trust delegation assertion");
        OptionBuilder.withArgName((String)"TDAssertion");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        uCCOptions2.addOption(OptionBuilder.create((String)"D"), "__SECURITY__");
        UCCOptions uCCOptions3 = this.getOptions();
        OptionBuilder.withLongOpt((String)"preference");
        OptionBuilder.withDescription((String)"User preference regarding choice of VO, role, UNIX login and groups which should be used for operation execution. The selected values must be allowed for the user. The uid option can be also set using U option. Full syntax: vo:<val>|role:<val>|uid:<val>|pgid:<val>|supgids:<val1,val2,...>|useOSgids:<true|false>");
        OptionBuilder.withArgName((String)PREFERENCE_ARG);
        OptionBuilder.hasArgs();
        OptionBuilder.isRequired((boolean)false);
        uCCOptions3.addOption(OptionBuilder.create((String)"Z"), "__SECURITY__");
    }

    private void createGeneralOptions() {
        UCCOptions uCCOptions = this.getOptions();
        OptionBuilder.withLongOpt((String)"configuration");
        OptionBuilder.withDescription((String)"Properties file containing your preferences. By default, a file '<userhome>/.ucc/preferences' is checked.");
        OptionBuilder.withArgName((String)"Properties");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        uCCOptions.addOption(OptionBuilder.create((String)"c"), "__GENERAL__");
        UCCOptions uCCOptions2 = this.getOptions();
        OptionBuilder.withLongOpt((String)"registry");
        OptionBuilder.withDescription((String)"Comma-separated list of UNICORE registry URLs");
        OptionBuilder.withArgName((String)"Registry");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        uCCOptions2.addOption(OptionBuilder.create((String)"r"), "__GENERAL__");
        UCCOptions uCCOptions3 = this.getOptions();
        OptionBuilder.withLongOpt((String)"user");
        OptionBuilder.withDescription((String)"The user id to use remotely");
        OptionBuilder.withArgName((String)"userID");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        uCCOptions3.addOption(OptionBuilder.create((String)"U"), "__GENERAL__");
    }

    private void createVOOptions() {
        UCCOptions uCCOptions = this.getOptions();
        OptionBuilder.withLongOpt((String)"VO");
        OptionBuilder.withDescription((String)"VO source (use full URL or use 'auto' to get the URL from the registry)");
        OptionBuilder.withArgName((String)"VO_URL");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        uCCOptions.addOption(OptionBuilder.create((String)"J"), "__VO__");
        UCCOptions uCCOptions2 = this.getOptions();
        OptionBuilder.withLongOpt((String)"attributeAssertion");
        OptionBuilder.withDescription((String)"Attribute assertion file");
        OptionBuilder.withArgName((String)"AssertionFile");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        uCCOptions2.addOption(OptionBuilder.create((String)"A"), "__VO__");
        UCCOptions uCCOptions3 = this.getOptions();
        OptionBuilder.withLongOpt((String)"includeAttributes");
        OptionBuilder.withDescription((String)"Regular expressions for included attributes (semicolon-separated); either names or name=value pairs");
        OptionBuilder.withArgName((String)"Regexes");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        uCCOptions3.addOption(OptionBuilder.create((String)"I"), "__VO__");
        UCCOptions uCCOptions4 = this.getOptions();
        OptionBuilder.withLongOpt((String)"excludeAttributes");
        OptionBuilder.withDescription((String)"Regular expressions for excluded attributes (semicolon-separated); either names or name=value pairs");
        OptionBuilder.withArgName((String)"Regexes");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        uCCOptions4.addOption(OptionBuilder.create((String)"Q"), "__VO__");
        UCCOptions uCCOptions5 = this.getOptions();
        OptionBuilder.withLongOpt((String)"voGroup");
        OptionBuilder.withDescription((String)"VO or VO and group name (for example: \"/vo/group\")");
        OptionBuilder.withArgName((String)"vogroup");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        uCCOptions5.addOption(OptionBuilder.create((String)"G"), "__VO__");
    }

    @Override
    public void process() {
        super.process();
        try {
            this.initSecurityProperties();
        }
        catch (Exception ioe) {
            this.error("Problem setting up security.", ioe);
            this.endProcessing(128);
        }
        if (!this.skipConnectingToRegistry()) {
            this.initRegistryClient();
        } else {
            this.verbose("Registry connection will be skipped.");
        }
        if (!this.skipConnectingToVO()) {
            this.connectVO();
        }
        this.setOutputLocation();
    }

    public IClientConfiguration getClientProperties() {
        return this.securityProperties;
    }

    protected void connectVO() {
        this.voURL = this.getOption("VO", "J");
        if ("auto".equals(this.voURL)) {
            ArrayList<String> voURLs = new ArrayList<String>();
            try {
                for (EntryType e : this.registry.listEntries()) {
                    EndpointReferenceType mepr = e.getMemberServiceEPR();
                    if (!mepr.isSetMetadata() || !mepr.getMetadata().xmlText().contains("UVOSAssertionQueryService")) continue;
                    voURLs.add(mepr.getAddress().getStringValue());
                }
            }
            catch (Exception ex) {
                this.error("Error when connection to registry", ex);
                this.endProcessing(1);
            }
            switch (voURLs.size()) {
                case 0: {
                    this.error("No VO server URL found in the registry", null);
                    this.endProcessing(1);
                    break;
                }
                case 1: {
                    this.voURL = (String)voURLs.get(0);
                    this.verbose("Found VO server URL: " + this.voURL);
                    break;
                }
                default: {
                    this.error("Multiple VO server URLs found:", null);
                    for (String url : voURLs) {
                        this.error(" " + url, null);
                    }
                    this.endProcessing(1);
                }
            }
        }
        this.attrAssertionFilename = this.getOption("attributeAssertion", "A");
        this.useSAMLPush = this.voURL != null && !this.voURL.equals("");
        this.useSAMLPush |= this.attrAssertionFilename != null && !this.attrAssertionFilename.equals("");
        if (!this.useSAMLPush) {
            return;
        }
        this.attributeFilter = VOAttributeFilter.build(this.getOption("includeAttributes", "I", null), this.getOption("excludeAttributes", "Q", null));
        if (this.attrAssertionFilename == null) {
            this.fetchAssertionFromServer();
        } else {
            this.loadAssertionFromFile();
        }
        this.addSAMLOutHandler((ClientProperties)this.securityProperties);
    }

    protected boolean skipConnectingToRegistry() {
        return !Boolean.parseBoolean(this.properties.getProperty("contact-registry", "true"));
    }

    protected boolean requireRegistry() {
        return true;
    }

    protected boolean skipConnectingToVO() {
        return false;
    }

    public void setSecurityProperties(IClientConfiguration sec) {
        this.securityProperties = sec;
    }

    protected void initSecurityProperties() throws Exception {
        if (this.securityProperties != null) {
            return;
        }
        this.loadUserProperties();
        String authNMethod = this.getOption("authenticationMethod", "k", "X509");
        Authentication authN = UCC.getAuthNMethod(authNMethod);
        if (authN == null) {
            throw new Exception("No such authentication method: " + authNMethod);
        }
        this.securityProperties = authN.initSecurityProperties(this.properties);
        this.securityProperties.getETDSettings().setExtendTrustDelegation(true);
        this.handleExtraConfigForOutHandlers();
    }

    private void handleExtraConfigForOutHandlers() {
        String[] configHandlers;
        for (String h : configHandlers = this.securityProperties.getOutHandlerClassNames()) {
            String propKey = h + ".";
            PropertyHelper ph = new PropertyHelper((Map)this.properties, new String[]{propKey});
            for (Map.Entry entry : ph.getFilteredMap().entrySet()) {
                String key = ((String)entry.getKey()).substring(propKey.length());
                String value = (String)entry.getValue();
                this.verbose("Setting handler property <" + key + ">");
                this.securityProperties.getExtraSettings().setProperty(key, value);
            }
        }
    }

    protected void setupExtraAttributes(ClientProperties sp) {
        String userID;
        String fromFile;
        String[] vals = this.getCommandLine().getOptionValues("Z");
        if (vals == null && (fromFile = this.properties.getProperty("preference")) != null) {
            vals = fromFile.split("( )+");
        }
        if (vals != null) {
            for (String val : vals) {
                this.parseSecurityPreference(val, sp);
            }
        }
        if ((userID = this.getOption("user", "U")) != null) {
            sp.getETDSettings().getRequestedUserAttributes2().put("xlogin", new String[]{userID});
        }
    }

    protected void parseSecurityPreference(String pref, ClientProperties sp) {
        if (pref.startsWith("uid:")) {
            String val = pref.substring(PREFERENCE_ARG_UID.length() + 1);
            sp.getETDSettings().getRequestedUserAttributes2().put("xlogin", new String[]{val});
        } else if (pref.startsWith("pgid:")) {
            String val = pref.substring(PREFERENCE_ARG_PGID.length() + 1);
            sp.getETDSettings().getRequestedUserAttributes2().put("group", new String[]{val});
        } else if (pref.startsWith("supgids:")) {
            String val = pref.substring(PREFERENCE_ARG_SUP_GIDS.length() + 1);
            String[] vals = val.split(",");
            sp.getETDSettings().getRequestedUserAttributes2().put("supplementaryGroups", vals);
        } else if (pref.startsWith("useOSgids:")) {
            String val = pref.substring(PREFERENCE_ARG_ADD_OS_GIDS.length() + 1);
            if (!val.equals("true") && !val.equals("false")) {
                this.error("Value of the useOSgids preferrence must be 'true' or 'false', but not '" + val + "'", null);
                this.endProcessing(2);
            }
            sp.getETDSettings().getRequestedUserAttributes2().put("addDefaultGroups", new String[]{val});
        } else if (pref.startsWith("vo:")) {
            String val = pref.substring(PREFERENCE_ARG_VO.length() + 1);
            sp.getETDSettings().getRequestedUserAttributes2().put("selectedVirtualOrganisation", new String[]{val});
        } else if (pref.startsWith("role:")) {
            String val = pref.substring(PREFERENCE_ARG_ROLE.length() + 1);
            sp.getETDSettings().getRequestedUserAttributes2().put(PREFERENCE_ARG_ROLE, new String[]{val});
        } else {
            this.error("Wrong value '" + pref + "' of the option -" + "Z" + ", must have the following format: " + PREFERENCE_ARG_HELP, null);
            this.endProcessing(2);
        }
    }

    protected List<TrustDelegation> getTDTokens() throws IOException {
        String tdPath = this.getOption("delegationAssertion", "D");
        if (tdPath == null) {
            return null;
        }
        File tdFile = new File(tdPath);
        try {
            AssertionDocument td = AssertionDocument.Factory.parse((File)tdFile);
            this.verbose("Read TD tokens from " + tdPath);
            ArrayList<TrustDelegation> res = new ArrayList<TrustDelegation>();
            res.add(new TrustDelegation(td));
            return res;
        }
        catch (Exception xe) {
            IOException e = new IOException("Attempted to create trust delegation token from invalid XML.");
            e.initCause(xe);
            throw e;
        }
    }

    protected void initRegistryClient() {
        this.registryURL = this.getCommandLine().getOptionValue("r", this.properties.getProperty("registry"));
        if (this.registryURL == null || this.registryURL.trim().length() == 0) {
            this.verbose("No registry is configured.");
            if (this.requireRegistry()) {
                throw new EndProcessingException(1, "A registry is required: please use the '-r' option or configuration entry to define the registry to be used.");
            }
            return;
        }
        this.verbose("Registry = " + this.registryURL);
        String[] urls = this.registryURL.split("[, ]");
        if (urls.length > 1) {
            MultiRegistryQuery erc = new MultiRegistryQuery(this);
            for (String url : urls) {
                if (url.trim().length() == 0) continue;
                this.verbose("Registry = " + url);
                try {
                    IRegistryQuery c = this.makeRegistry(url);
                    erc.addRegistry(c);
                }
                catch (Exception e) {
                    this.error("Cannot contact registry <" + url + ">", null);
                }
            }
            this.registry = erc;
        } else {
            try {
                this.registry = this.makeRegistry(this.registryURL);
                this.testRegistryConnection();
            }
            catch (Exception e) {
                this.error("Cannot contact registry", e);
                this.endProcessing();
            }
        }
    }

    protected IRegistryQuery makeRegistry(String url) throws Exception {
        ServiceLoader<IRegistryFactory> sl = ServiceLoader.load(IRegistryFactory.class);
        for (IRegistryFactory f : sl) {
            try {
                IRegistryQuery q = f.create(url, this.securityProperties, this);
                if (q == null) continue;
                return q;
            }
            catch (Throwable ex) {
                this.error("Problem trying to create registry client using " + f.getClass().getName(), ex);
            }
        }
        return null;
    }

    protected void testRegistryConnection() {
        try {
            this.verbose("Checking registry connection.");
            String status = this.registry.getConnectionStatus();
            this.verbose("Registry connection status: " + status);
        }
        catch (ClientException e) {
            this.error("Cannot contact registry", e);
            this.endProcessing(2);
        }
    }

    protected String findServerName(EndpointReferenceType epr) throws Exception {
        String dn = WSUtilities.extractServerIDFromEPR((EndpointReferenceType)epr);
        if (dn != null) {
            return dn;
        }
        String url = epr.getAddress().getStringValue();
        if (url.contains("/services/")) {
            url = url.substring(0, url.indexOf("/services"));
        }
        this.verbose("Checking for services at " + url);
        for (EntryType entry : this.registry.listEntries()) {
            if (!entry.getMemberServiceEPR().getAddress().getStringValue().startsWith(url) || (dn = WSUtilities.extractServerIDFromEPR((EndpointReferenceType)entry.getMemberServiceEPR())) == null) continue;
            return dn;
        }
        return null;
    }

    private void loadAssertionFromFile() {
        File assertionFile = new File(this.attrAssertionFilename);
        if (!assertionFile.exists() || !assertionFile.canRead()) {
            this.error("Assertion file " + assertionFile.getAbsolutePath() + " does not exist or is not readable.", null);
            this.endProcessing(2);
        }
        try {
            AssertionDocument a = AssertionDocument.Factory.parse((File)assertionFile);
            this.assertionInstallCommon(new Assertion(a));
        }
        catch (Exception ex) {
            this.error("Error loading assertion from " + assertionFile.getAbsolutePath(), ex);
            this.endProcessing(2);
        }
    }

    protected void fetchAssertionFromServer() {
        String group = this.getOption("voGroup", "G", null);
        try {
            AttributeAssertionFetcher fetcher = new AttributeAssertionFetcher(this.securityProperties, this.voURL);
            Assertion a = fetcher.fetchAssertion(group, this.attributeFilter);
            this.assertionInstallCommon(a);
        }
        catch (Exception ex) {
            this.error(ex.getMessage(), ex);
            this.endProcessing(128);
        }
    }

    private void assertionInstallCommon(Assertion assertion) throws JDOMException, IOException {
        this.rawSAMLAssertion = assertion;
        this.rawXmlSAMLAssertions = Arrays.asList(ActionBase.convertAssertion(this.rawSAMLAssertion));
        if (this.rawXmlSAMLAssertions != null) {
            Map secContext = this.securityProperties.getExtraSecurityTokens();
            secContext.put(SAMLAttributePushOutHandler.PUSHED_RAW_ASSERTIONS, this.rawXmlSAMLAssertions);
        }
    }

    private void addSAMLOutHandler(ClientProperties sp) {
        String[] outHandlers;
        if (!this.useSAMLPush) {
            return;
        }
        for (String h : outHandlers = sp.getOutHandlerClassNames()) {
            if (!h.equals(SAMLAttributePushOutHandler.class.getName())) continue;
            return;
        }
        outHandlers = Arrays.copyOf(outHandlers, outHandlers.length + 1);
        outHandlers[outHandlers.length - 1] = SAMLAttributePushOutHandler.class.getName();
        sp.setOutHandlerClassNames(outHandlers);
    }

    private static Element convertAssertion(Assertion a) throws JDOMException, IOException {
        return new SAXBuilder().build(a.getXML().newInputStream()).detachRootElement();
    }
}

