/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.actions;

import de.fzj.unicore.uas.client.JobClient;
import de.fzj.unicore.ucc.actions.ActionBase;
import de.fzj.unicore.ucc.util.Builder;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class AbortJob
extends ActionBase {
    private Builder builder;
    private JobClient job;

    protected void initBuilder() {
        String arg = null;
        if (this.getCommandLine().getArgs().length > 1) {
            arg = this.getCommandLine().getArgs()[1];
        }
        String url = null;
        if (arg == null) {
            try {
                arg = new BufferedReader(new InputStreamReader(System.in)).readLine();
            }
            catch (Exception e) {
                System.err.println("Can't read job descriptor from stdin.");
                this.endProcessing(2);
            }
        }
        this.initFromCmdline(arg);
        url = this.builder.getProperty("epr");
        if (url == null) {
            System.err.println("Job EPR not found! Maybe <" + arg + "> has not been produced by ucc.");
            this.endProcessing(2);
        }
        try {
            EndpointReferenceType epr = EndpointReferenceType.Factory.newInstance();
            epr.addNewAddress().setStringValue(url);
            this.job = new JobClient(url, epr, this.securityProperties);
            this.job.getCurrentTime();
            this.verbose("Job ID OK.");
        }
        catch (Exception e) {
            this.error("Can't contact job", e);
            this.endProcessing(1);
        }
    }

    private void initFromCmdline(String arg) {
        try {
            File job = new File(arg);
            if (job.exists()) {
                this.builder = new Builder(job);
                this.verbose("Read job from <" + arg + ">");
            } else {
                this.verbose("Accessing job at EPR = <" + arg + ">");
                this.builder = new Builder();
                this.builder.setProperty("epr", arg);
            }
        }
        catch (Exception e) {
            this.error("Can't use <" + arg + ">.", e);
            this.endProcessing(2);
        }
    }

    @Override
    public void process() {
        super.process();
        this.initBuilder();
        this.abort();
    }

    @Override
    public String getName() {
        return "abort-job";
    }

    @Override
    public String getArgumentList() {
        return "[<jobfile> | <jobepr>]";
    }

    @Override
    public String getSynopsis() {
        return "Aborts a UNICORE 6 job. The job is referenced either by a job file as written by the 'run' command or as an EPR.";
    }

    @Override
    public String getDescription() {
        return "abort a job";
    }

    @Override
    public String getCommandGroup() {
        return "Job execution";
    }

    protected void abort() {
        try {
            this.verbose("Job id: " + this.job.getEPR().getAddress().getStringValue());
            this.job.abort();
            this.message("Job aborted.");
        }
        catch (Exception e) {
            this.error("Can't abort job.", e);
            this.endProcessing(1);
        }
    }
}

