/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.actions;

import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.ucc.UCCOptions;
import de.fzj.unicore.ucc.actions.Chmod;
import de.fzj.unicore.ucc.actions.SMSOperation;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.unigrids.services.atomic.types.ACLEntryTypeType;
import org.unigrids.x2006.x04.services.sms.ACLChangeModeType;
import org.unigrids.x2006.x04.services.sms.ChangeACLEntryType;

public class ACL
extends SMSOperation {
    public static final String OPT_CLEAN_LONG = "clean";
    public static final String OPT_CLEAN = "b";
    public static final String OPT_DELETE_LONG = "delete";
    public static final String OPT_DELETE = "d";

    @Override
    protected void createOptions() {
        super.createOptions();
        UCCOptions uCCOptions = this.getOptions();
        OptionBuilder.withLongOpt((String)"recursive");
        OptionBuilder.withDescription((String)"Recursively applies the operation to the whole contents of the directory specified as an argument.");
        OptionBuilder.isRequired((boolean)false);
        uCCOptions.addOption(OptionBuilder.create((String)"R"));
        UCCOptions uCCOptions2 = this.getOptions();
        OptionBuilder.withLongOpt((String)OPT_CLEAN_LONG);
        OptionBuilder.withDescription((String)"Prior to applying all other ACLs (if any are present) all ACL of the path are cleaned.");
        OptionBuilder.isRequired((boolean)false);
        uCCOptions2.addOption(OptionBuilder.create((String)OPT_CLEAN));
        UCCOptions uCCOptions3 = this.getOptions();
        OptionBuilder.withLongOpt((String)OPT_DELETE_LONG);
        OptionBuilder.withDescription((String)"Specified ACEs are deleted from the path's ACL (if this option is not specified then ACEs are added).");
        OptionBuilder.isRequired((boolean)false);
        uCCOptions3.addOption(OptionBuilder.create((String)OPT_DELETE));
    }

    @Override
    public String getName() {
        return "setacl";
    }

    @Override
    public String getSynopsis() {
        return "Changes ACL of a file on a remote storage. By default the command will add the specified Access Control Entries (ACEs) to the path's ACL. With the 'delete' option the ACEs are removed. The ACEs specification is required always unless the 'clean' option is specified. The ACE syntax is as follows:\n\n[d:]<g|u>:[subject]:[permissons]\n\nwhere: 'd' stands for the default directory ACL, 'g' or 'u' for the group or user ACL. Permissions are in the 'rwx' format with '-' where appropriate. Capital X is also supported.Note that permissions part is required always unless the ACE is going to be removed.\nExample specification of two ACEs suitable for adding to a directory:\ng:wheel:rwx,d:u::r-x\nThis example will add rwx permissions to the wheel group and set the default user ACL r-x (the default ACL will be used for the contents subsequently created in the directory).";
    }

    @Override
    public String getDescription() {
        return "change file's ACL";
    }

    @Override
    public String getArgumentList() {
        return "[ACE[,ACE...]] <[Storage-URL#]/path or [u6://SITENAME/[JobId|StorageName]]/path>";
    }

    @Override
    public String getCommandGroup() {
        return "Data management";
    }

    @Override
    public void process() {
        String target;
        super.process();
        boolean recursive = this.getBooleanOption("recursive", "R");
        this.verbose("Recursive invocation = " + recursive);
        boolean clean = this.getBooleanOption(OPT_CLEAN_LONG, OPT_CLEAN);
        this.verbose("Clean up ACL = " + clean);
        boolean remove = this.getBooleanOption(OPT_DELETE_LONG, OPT_DELETE);
        this.verbose("Delete ACEs = " + remove);
        CommandLine cmdLine = this.getCommandLine();
        if (clean && cmdLine.getArgs().length < 2 || !clean && cmdLine.getArgs().length < 3) {
            this.error("Not enough arguments", null);
            this.printUsage();
            this.endProcessing(2);
        }
        ChangeACLEntryType[] spec = null;
        if (cmdLine.getArgs().length > 2) {
            spec = this.parseACEs(cmdLine.getArgs()[1], remove);
            target = cmdLine.getArgs()[2];
        } else {
            target = cmdLine.getArgs()[1];
        }
        this.verbose("Modifying ACLs of: " + target);
        StorageClient sms = this.getStorageClient(target);
        try {
            String path = this.getPathAtStorage(target);
            sms.setACL(path, clean, spec, recursive);
        }
        catch (Exception ex) {
            this.error("Error during ACL manipulation.", ex);
            this.endProcessing(1);
        }
    }

    private ChangeACLEntryType[] parseACEs(String spec, boolean remove) {
        String[] specA = spec.split(",");
        ChangeACLEntryType[] ret = new ChangeACLEntryType[specA.length];
        for (int i = 0; i < specA.length; ++i) {
            ret[i] = ChangeACLEntryType.Factory.newInstance();
            if (!remove) {
                ret[i].setMode(ACLChangeModeType.MODIFY);
            } else {
                ret[i].setMode(ACLChangeModeType.REMOVE);
            }
            String[] entries = this.splitStrict(specA[i]);
            if (entries.length < 3) {
                this.errorACE(specA[i]);
            }
            int off = 0;
            ret[i].setDefaultACL(false);
            if (entries[0].equals(OPT_DELETE)) {
                ++off;
                ret[i].setDefaultACL(true);
                if (entries.length < 4) {
                    this.errorACE(specA[i]);
                }
            }
            if (entries[off].equals("u")) {
                ret[i].setKind(ACLEntryTypeType.USER);
            } else if (entries[off].equals("g")) {
                ret[i].setKind(ACLEntryTypeType.GROUP);
            } else {
                this.errorACE(specA[i]);
            }
            ret[i].setSubject(entries[++off]);
            if (remove) {
                ret[i].setPermissions("");
            } else {
                if (entries.length == ++off) {
                    this.errorACE(specA[i]);
                }
                if (!Chmod.pattern.matcher(entries[off]).matches()) {
                    this.errorACE(specA[i]);
                }
                ret[i].setPermissions(entries[off]);
            }
            if (!this.isVerbose()) continue;
            this.verbose("Parsed " + specA[i] + " into:\n" + ret[i].xmlText());
        }
        return ret;
    }

    private void errorACE(String ace) {
        this.error("Invalid format of ACE: " + ace, null);
        this.printUsage();
        this.endProcessing(2);
    }

    private String[] splitStrict(String toSplit) {
        ArrayList<String> retList = new ArrayList<String>();
        char[] chars = toSplit.toCharArray();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == ':') {
                retList.add(sb.toString());
                sb = new StringBuilder();
                continue;
            }
            sb.append(chars[i]);
        }
        retList.add(sb.toString());
        return retList.toArray(new String[retList.size()]);
    }
}

