/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class UCCOptions
extends Options {
    private static final long serialVersionUID = 1L;
    private final Set<String> usedOptionNames = new HashSet<String>();
    public static final String GRP_DEFAULT = "__DEFAULT__";
    public static final String GRP_GENERAL = "__GENERAL__";
    public static final String GRP_SECURITY = "__SECURITY__";
    public static final String GRP_VO = "__VO__";
    private final Map<String, List<Option>> optionGroups = new HashMap<String, List<Option>>();

    private void markAsUsed(String optionName) {
        if (this.usedOptionNames.contains(optionName)) {
            throw new IllegalArgumentException("The option '" + optionName + "' has already been registered before.");
        }
        this.usedOptionNames.add(optionName);
    }

    public Options addOption(Option option) {
        return this.addOption(option, GRP_DEFAULT);
    }

    public Options addOption(Option option, String optionGroup) {
        this.markAsUsed(option.getLongOpt());
        this.markAsUsed(option.getOpt());
        Options result = super.addOption(option);
        List<Option> grp = this.optionGroups.get(optionGroup);
        if (grp == null) {
            grp = new ArrayList<Option>();
            this.optionGroups.put(optionGroup, grp);
        }
        grp.add(option);
        return result;
    }

    private List<Option> getOptionsGroup(String name) {
        return this.optionGroups.get(name);
    }

    public Options getDefaultOptions() {
        List<Option> defOpts = this.getOptionsGroup(GRP_DEFAULT);
        if (defOpts == null) {
            return null;
        }
        Options res = new Options();
        for (Option o : defOpts) {
            res.addOption(o);
        }
        return res;
    }

    public Options getGeneralOptions() {
        List<Option> secOpts = this.getOptionsGroup(GRP_GENERAL);
        if (secOpts == null) {
            return null;
        }
        Options res = new Options();
        for (Option o : secOpts) {
            res.addOption(o);
        }
        return res;
    }

    public Options getSecurityOptions() {
        List<Option> secOpts = this.getOptionsGroup(GRP_SECURITY);
        if (secOpts == null) {
            return null;
        }
        Options res = new Options();
        for (Option o : secOpts) {
            res.addOption(o);
        }
        return res;
    }

    public Options getVOOptions() {
        List<Option> voOpts = this.getOptionsGroup(GRP_VO);
        if (voOpts == null) {
            return null;
        }
        Options res = new Options();
        for (Option o : voOpts) {
            res.addOption(o);
        }
        return res;
    }
}

