/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc;

import de.fzj.unicore.ucc.Command;
import de.fzj.unicore.ucc.MessageWriter;
import de.fzj.unicore.ucc.ProvidedCommands;
import de.fzj.unicore.ucc.authn.Authentication;
import de.fzj.unicore.ucc.helpers.DefaultMessageWriter;
import de.fzj.unicore.ucc.helpers.EndProcessingException;
import eu.unicore.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import org.apache.commons.cli.ParseException;

public class UCC {
    public static boolean unitTesting = false;
    public static boolean mute = false;
    public static final Map<String, Class<? extends Command>> cmds = new HashMap<String, Class<? extends Command>>();
    public static final Map<String, Authentication> authNMethods = new HashMap<String, Authentication>();
    public static final String UCC_EXTENSIONS = "ucc.extensions";
    public static Integer exitCode = null;
    public static NumberFormat numberFormat = NumberFormat.getInstance();
    private static MessageWriter msg = new DefaultMessageWriter();

    public static String getVersion() {
        String v = UCC.class.getPackage().getImplementationVersion();
        if (v == null) {
            v = "(DEVELOPMENT version)";
        }
        return v;
    }

    public static void printUsage(boolean exit) {
        String version = UCC.getVersion();
        System.err.println("UCC " + version);
        System.err.println("Usage: ucc <command> [OPTIONS] <args>");
        System.err.println("The following commands are available:");
        List<Command> cmds = UCC.getAllCommands();
        Collections.sort(cmds, new Comparator<Command>(){

            @Override
            public int compare(Command e1, Command e2) {
                return e1.getCommandGroup().compareTo(e2.getCommandGroup());
            }
        });
        String lastGroup = "";
        for (Command entry : cmds) {
            String group = entry.getCommandGroup();
            if (!group.equalsIgnoreCase(lastGroup)) {
                System.err.println(group + ":");
                lastGroup = group;
            }
            System.err.printf(" %-20s - %s", entry.getName(), entry.getDescription());
            System.err.println();
        }
        System.err.println("Enter 'ucc help-auth' for help on authentication options.");
        System.err.println("Enter 'ucc <command> -h' for help on a particular command.");
        if (exit && !unitTesting) {
            System.exit(1);
        }
    }

    public static void printUsage() {
        UCC.printUsage(true);
    }

    public static void printAuthNUsage() {
        String version = UCC.getVersion();
        System.out.println("UCC " + version);
        System.out.println("The following authentication methods are available:");
        for (Authentication entry : authNMethods.values()) {
            System.out.println();
            System.out.printf(" %-20s - %s", entry.getName(), entry.getDescription());
            System.out.println();
            entry.printUsage();
        }
    }

    public static void loadUserActions() {
        String filename = System.getProperty(UCC_EXTENSIONS);
        try {
            File propFile = null;
            if (filename != null) {
                propFile = new File(filename);
                if (!propFile.exists()) {
                    System.err.println("The extensions file <" + filename + "> does not exist.");
                    return;
                }
            } else {
                filename = System.getProperty("user.home") + File.separator + ".ucc" + File.separator + "extensions";
                propFile = new File(filename);
                if (!propFile.exists()) {
                    return;
                }
            }
            Properties p = new Properties();
            p.load(new FileInputStream(propFile));
            for (Object key : p.keySet()) {
                String cmdName = (String)key;
                String cmdClazz = p.getProperty(cmdName).trim();
                try {
                    Class<?> cmdClass = Class.forName(cmdClazz);
                    if (!Command.class.isAssignableFrom(cmdClass)) continue;
                    Command cmd = (Command)cmdClass.newInstance();
                    cmds.put(cmdName, cmd.getClass());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.err.println("Could not load user action <" + key + ">, please check the " + "extensions file <" + filename + ">.");
                }
            }
        }
        catch (Exception e) {
            System.err.println("Could not load user actions, please check the extensions file <" + filename + ">.");
        }
    }

    public static Command initCommand(String[] args, boolean shouldQuit) throws ParseException {
        String command = args[0];
        Class<? extends Command> cmdClass = cmds.get(command);
        if (cmdClass == null) {
            UCC.printUsage(shouldQuit);
            return null;
        }
        Command cmd = UCC.getCommand(command);
        try {
            cmd.init(args);
        }
        catch (ParseException pe) {
            cmd.printUsage();
            throw pe;
        }
        return cmd;
    }

    public static Command getCommand(String name) {
        Class<? extends Command> cmdClass = cmds.get(name);
        if (cmdClass == null) {
            throw new IllegalArgumentException("No such command: " + name);
        }
        try {
            return cmdClass.newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not instantiate " + cmdClass.getName(), ex);
        }
    }

    public static List<Command> getAllCommands() {
        ArrayList<Command> result = new ArrayList<Command>();
        for (Class<? extends Command> c : cmds.values()) {
            try {
                result.add(c.newInstance());
            }
            catch (Exception ex) {
                msg.error("Could not instantiate " + c.getName(), ex);
            }
        }
        return result;
    }

    public static Authentication getAuthNMethod(String name) {
        return authNMethods.get(name);
    }

    public static void main(String[] args) {
        UCC.loadUserActions();
        Command cmd = null;
        exitCode = null;
        try {
            boolean showAuthNHelp;
            boolean showHelp = args.length < 1 || args[0].equalsIgnoreCase("help") || args[0].equalsIgnoreCase("-h");
            boolean bl = showAuthNHelp = args.length == 1 && args[0].equalsIgnoreCase("help-auth");
            if (showHelp) {
                UCC.printUsage(!unitTesting);
            } else if (showAuthNHelp) {
                UCC.printAuthNUsage();
            } else {
                cmd = UCC.initCommand(args, !unitTesting);
                cmd.process();
                cmd.postProcess();
            }
            exitCode = 0;
        }
        catch (EndProcessingException epe) {
            exitCode = epe.getExitCode();
        }
        catch (ParseException pe) {
            System.err.println("Error parsing commandline");
            pe.printStackTrace();
            exitCode = 1;
        }
        catch (Exception e) {
            if (cmd == null) {
                String msg = Log.createFaultMessage((String)("Error setting up UCC command '" + args[0] + "'"), (Throwable)e);
                System.err.println(msg);
            } else {
                cmd.error("An error occurred.", e);
            }
            exitCode = 1;
        }
        if (!unitTesting) {
            System.exit(exitCode);
        }
    }

    public static MessageWriter getMessageWriter() {
        return msg;
    }

    public static void setMessageWriter(MessageWriter writer) {
        msg = writer;
    }

    static {
        try {
            ServiceLoader<ProvidedCommands> sl = ServiceLoader.load(ProvidedCommands.class);
            for (ProvidedCommands providedCommands : sl) {
                try {
                    Command[] commands;
                    for (Command cmd : commands = providedCommands.getCommands()) {
                        cmds.put(cmd.getName(), cmd.getClass());
                    }
                }
                catch (Exception ex) {
                    msg.error("Could not load commands for provider " + providedCommands.getClass(), ex);
                }
            }
        }
        catch (Exception ex) {
            msg.error("Could not load commands!", ex);
        }
        try {
            ServiceLoader<Authentication> authn = ServiceLoader.load(Authentication.class);
            for (Authentication authentication : authn) {
                try {
                    authNMethods.put(authentication.getName(), authentication);
                }
                catch (Exception ex) {
                    msg.error("Problem with AuthN provider " + authentication.getClass(), ex);
                }
            }
        }
        catch (Exception ex) {
            msg.error("Could not load AuthN options!", ex);
        }
        numberFormat.setMaximumFractionDigits(2);
    }
}

