/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc;

import de.fzj.unicore.ucc.Constants;
import de.fzj.unicore.ucc.MessageWriter;
import de.fzj.unicore.ucc.UCC;
import de.fzj.unicore.ucc.UCCOptions;
import de.fzj.unicore.ucc.helpers.EndProcessingException;
import java.io.File;
import java.io.FileInputStream;
import java.text.NumberFormat;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;

public abstract class Command
implements Constants,
MessageWriter {
    protected static final Logger logger = Logger.getLogger((String)"UCC");
    private final UCCOptions options;
    private CommandLine line;
    protected boolean verbose;
    protected long startTime;
    protected long endTime;
    protected boolean timing;
    public static boolean quitAfterPrintingUsage;
    protected File propertiesFile;
    protected Properties properties = null;
    protected NumberFormat numberFormat = UCC.numberFormat;
    protected File output;

    public Command() {
        this.options = new UCCOptions();
        this.createOptions();
    }

    public void init(String[] args) throws ParseException {
        if (this.handleHelp(args)) {
            this.printUsage();
            this.endProcessing(0);
        }
        GnuParser parser = new GnuParser();
        this.line = parser.parse((Options)this.getOptions(), args);
        UCC.setMessageWriter(this);
    }

    protected void setOutputLocation() {
        this.verbose("Current directory is <" + new File("").getAbsolutePath() + ">");
        String outputLoc = this.getCommandLine().getOptionValue("o", this.properties.getProperty("output"));
        if (outputLoc == null) {
            outputLoc = ".";
        }
        try {
            this.output = new File(outputLoc);
            if (!this.output.exists()) {
                this.output.mkdirs();
            }
            if (!this.output.isDirectory()) {
                throw new IllegalArgumentException("<" + outputLoc + "> is not a directory.");
            }
            this.verbose("Output goes to <" + outputLoc + ">");
        }
        catch (Exception e) {
            this.error("Problem with <" + outputLoc + ">", e);
            this.endProcessing();
        }
    }

    private boolean handleHelp(String[] args) {
        String help = "-h";
        String help_long = "--help";
        for (String arg : args) {
            if (!help.equals(arg) && !help_long.equals(arg)) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return "<command>";
    }

    public String getArgumentList() {
        return "[ARGS]";
    }

    public String getSynopsis() {
        return "";
    }

    public String getDescription() {
        return "";
    }

    public String getCommandGroup() {
        return "Other";
    }

    public UCCOptions getOptions() {
        return this.options;
    }

    public CommandLine getCommandLine() {
        return this.line;
    }

    protected void endProcessing() {
        this.endProcessing(0);
    }

    protected void endProcessing(int exitCode) {
        if (!quitAfterPrintingUsage) {
            throw new EndProcessingException(exitCode);
        }
        System.exit(exitCode);
    }

    protected void createOptions() {
        this.getOptions().addOption(new Option("h", "help", false, "Print this help message"), "__GENERAL__");
        UCCOptions uCCOptions = this.getOptions();
        OptionBuilder.withLongOpt((String)"verbose");
        OptionBuilder.withDescription((String)"Verbose mode");
        OptionBuilder.withArgName((String)"Verbose");
        OptionBuilder.isRequired((boolean)false);
        uCCOptions.addOption(OptionBuilder.create((String)"v"), "__GENERAL__");
        if (this.isTimeable()) {
            UCCOptions uCCOptions2 = this.getOptions();
            OptionBuilder.withLongOpt((String)"with-timing");
            OptionBuilder.withDescription((String)"Timing mode");
            OptionBuilder.isRequired((boolean)false);
            uCCOptions2.addOption(OptionBuilder.create((String)"y"), "__GENERAL__");
        }
        if (this.producesOutput()) {
            UCCOptions uCCOptions3 = this.getOptions();
            OptionBuilder.withLongOpt((String)"output");
            OptionBuilder.withDescription((String)"Directory for any output produced");
            OptionBuilder.withArgName((String)"Output");
            OptionBuilder.hasArg();
            OptionBuilder.isRequired((boolean)false);
            uCCOptions3.addOption(OptionBuilder.create((String)"o"), "__GENERAL__");
        }
    }

    protected boolean producesOutput() {
        return true;
    }

    protected boolean isTimeable() {
        return true;
    }

    public void printUsage() {
        HelpFormatter formatter = new HelpFormatter();
        String syntax = "ucc " + this.getName() + " [OPTIONS] " + this.getArgumentList() + "\n" + this.getSynopsis() + "\n";
        String newLine = System.getProperty("line.separator");
        if (!UCC.mute) {
            Options vo;
            Options security;
            Options def = this.options.getDefaultOptions();
            if (def != null) {
                formatter.printHelp(syntax, def);
            } else {
                formatter.printHelp(syntax, new Options());
            }
            Options general = this.options.getGeneralOptions();
            if (general != null) {
                System.out.println();
                formatter.setSyntaxPrefix("General options:");
                formatter.printHelp(" " + newLine, general);
            }
            if ((security = this.options.getSecurityOptions()) != null) {
                System.out.println();
                formatter.setSyntaxPrefix("Security options:");
                formatter.printHelp(" " + newLine, security);
            }
            if ((vo = this.options.getVOOptions()) != null) {
                System.out.println();
                formatter.setSyntaxPrefix("VO-related options:");
                formatter.printHelp(" " + newLine, vo);
            }
        }
    }

    public void process() {
        if (this.getCommandLine().hasOption("h")) {
            this.printUsage();
            this.endProcessing();
        }
        if (this.getCommandLine().hasOption("v")) {
            this.verbose = true;
        }
        this.loadUserProperties();
        this.verbose = this.getBooleanOption("verbose", "v");
        this.timing = this.getBooleanOption("with-timing", "y");
        if (this.timing) {
            this.startTime = System.currentTimeMillis();
            this.verbose("Timing mode.");
        }
        this.setOutputLocation();
    }

    public final void postProcess() {
        if (this.timing) {
            this.endTime = System.currentTimeMillis();
            float duration = (this.endTime - this.startTime) / 1000L;
            this.message("Time: " + this.numberFormat.format(duration) + " sec.");
        }
    }

    protected void loadUserProperties() {
        if (this.properties != null) {
            return;
        }
        this.verbose("UCC " + UCC.getVersion() + ", http://www.unicore.eu");
        this.properties = new Properties();
        boolean userSpecified = false;
        CommandLine line = this.getCommandLine();
        String defaultProps = System.getProperty("user.home") + File.separator + ".ucc" + File.separator + "preferences";
        String props = System.getProperty("ucc.preferences", defaultProps);
        if (line.hasOption("c")) {
            props = line.getOptionValue("c");
            this.verbose("Properties file: <" + props + ">");
            userSpecified = true;
        }
        this.propertiesFile = new File(props);
        if (this.propertiesFile.exists()) {
            this.verbose("Reading properties file <" + props + ">");
            try {
                this.propertiesFile = new File(props);
                this.properties.load(new FileInputStream(this.propertiesFile));
            }
            catch (Exception e) {
                this.error("Could not read from <" + props + ">.", e);
                this.endProcessing(1);
            }
        } else if (userSpecified) {
            this.error("Properties file <" + props + "> does not exist.", null);
            this.endProcessing(1);
        } else {
            this.verbose("No properties file found at <" + props + ">");
        }
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    protected int getNumericOption(String longForm, String shortForm, int defaultValue) {
        String val = this.getCommandLine().getOptionValue(shortForm, this.properties.getProperty(longForm, "" + defaultValue));
        try {
            return Integer.parseInt(val);
        }
        catch (Exception e) {
            this.error("Can't parse supplied value for option <" + longForm + ">, using default <" + defaultValue + ">", e);
            return defaultValue;
        }
    }

    protected boolean getBooleanOption(String longForm, String shortForm) {
        String val = this.getCommandLine().hasOption(shortForm) ? "true" : this.properties.getProperty(longForm, "false");
        return Boolean.parseBoolean(val);
    }

    protected String getOption(String longForm, String shortForm) {
        return this.getOption(longForm, shortForm, null);
    }

    protected String getOption(String longForm, String shortForm, String defaultValue) {
        String val = this.getCommandLine().hasOption(shortForm) ? this.getCommandLine().getOptionValue(shortForm) : this.properties.getProperty(longForm, defaultValue);
        return val;
    }

    @Override
    public void verbose(String message) {
        if (this.verbose) {
            System.out.println("[ucc " + this.getName() + "] " + message);
        }
        logger.debug((Object)message);
    }

    @Override
    public void message(String message) {
        if (UCC.mute) {
            return;
        }
        System.out.println(message);
        logger.info((Object)message);
    }

    @Override
    public void error(String message, Throwable cause) {
        System.err.println(message);
        if (cause != null) {
            System.err.println("The root error was: " + Command.getDetailMessage(cause));
            if (this.verbose) {
                cause.printStackTrace();
            } else {
                System.err.println("Re-run in verbose mode (-v) to see the full error stack trace.");
            }
        }
        logger.error((Object)message, cause);
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    public static String getDetailMessage(Throwable throwable) {
        StringBuilder sb = new StringBuilder();
        Throwable cause = throwable;
        String message = null;
        String type = null;
        type = cause.getClass().getName();
        do {
            type = cause.getClass().getName();
            message = cause.getMessage();
        } while ((cause = cause.getCause()) != null);
        if (message != null) {
            sb.append(type).append(": ").append(message);
        } else {
            sb.append(type).append(" (no further message available)");
        }
        return sb.toString();
    }

    public void setOutputDirectory(File output) {
        this.output = output;
    }
}

