/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.nonstop;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.constructs.nonstop.NonstopExecutorService;
import net.sf.ehcache.constructs.nonstop.NonstopThreadPool;
import net.sf.ehcache.constructs.nonstop.TaskNotSubmittedTimeoutException;
import net.sf.ehcache.constructs.nonstop.ThrowTimeoutException;
import net.sf.ehcache.constructs.nonstop.concurrency.InvalidLockStateAfterRejoinException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonstopExecutorServiceImpl
implements NonstopExecutorService {
    private final NonstopThreadPool nonstopThreadPool;

    public NonstopExecutorServiceImpl(ThreadFactory threadFactory) {
        this.nonstopThreadPool = new NonstopThreadPool(threadFactory);
    }

    @Override
    public <V> V execute(Callable<V> callable, long timeoutValueInMillis) throws TimeoutException, CacheException, InterruptedException {
        int attempt = 0;
        V result = null;
        long startTime = System.nanoTime();
        while (true) {
            try {
                ++attempt;
                result = this.nonstopThreadPool.submit(callable).get(timeoutValueInMillis, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (RejectedExecutionException e) {
                long now;
                if ((now = System.nanoTime()) - startTime <= TimeUnit.NANOSECONDS.convert(timeoutValueInMillis, TimeUnit.MILLISECONDS)) continue;
                throw new TaskNotSubmittedTimeoutException(attempt);
            }
            catch (ExecutionException e) {
                Throwable rootCause = this.getRootCause(e);
                if (rootCause.getClass().getSimpleName().equals("TCNotRunningException")) {
                    throw new TimeoutException(rootCause.getMessage());
                }
                if (rootCause instanceof ThrowTimeoutException) {
                    throw new TimeoutException("Callable threw " + ThrowTimeoutException.class.getName());
                }
                if (e.getCause() instanceof InvalidLockStateAfterRejoinException) {
                    throw new InvalidLockStateAfterRejoinException(e.getCause());
                }
                throw new CacheException(e.getCause());
            }
            catch (TimeoutException e) {
                throw e;
            }
            break;
        }
        return result;
    }

    private Throwable getRootCause(Throwable exception) {
        Throwable e = exception;
        while (e.getCause() != null) {
            e = e.getCause();
        }
        return e;
    }

    @Override
    public void shutdown() {
        this.nonstopThreadPool.shutdownNow();
    }
}

