/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.admin;

import de.fzj.unicore.uas.TargetSystemFactory;
import de.fzj.unicore.ucc.UCCOptions;
import de.fzj.unicore.ucc.actions.ActionBase;
import de.fzj.unicore.wsrflite.xmlbeans.client.AdminServiceClient;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.OptionBuilder;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class RunCommand
extends ActionBase {
    public static final String OPT_URL_LONG = "url";
    public static final String OPT_URL = "u";
    private String siteName;
    private String url;
    private String cmd;
    private final Map<String, String> params = new HashMap<String, String>();

    protected void createOptions() {
        super.createOptions();
        UCCOptions uCCOptions = this.getOptions();
        OptionBuilder.withLongOpt((String)"sitename");
        OptionBuilder.withDescription((String)"Site Name");
        OptionBuilder.withArgName((String)"Vsite");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        uCCOptions.addOption(OptionBuilder.create((String)"s"));
        UCCOptions uCCOptions2 = this.getOptions();
        OptionBuilder.withLongOpt((String)OPT_URL_LONG);
        OptionBuilder.withDescription((String)"Admin service URL");
        OptionBuilder.withArgName((String)"URL");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        uCCOptions2.addOption(OptionBuilder.create((String)OPT_URL));
    }

    public void process() {
        super.process();
        int length = this.getCommandLine().getArgs().length;
        if (length < 2) {
            throw new IllegalArgumentException("You must provide at least a command name as argument.");
        }
        this.params.clear();
        this.cmd = this.getCommandLine().getArgs()[1];
        for (int i = 2; i < length; ++i) {
            String p = this.getCommandLine().getArgs()[i];
            String[] split = p.split("=");
            String key = split[0];
            String value = split[1];
            this.verbose("Have parameter: " + key + "=" + value);
            this.params.put(key, value);
        }
        this.siteName = this.getCommandLine().getOptionValue("s");
        this.url = this.getCommandLine().getOptionValue(OPT_URL);
        if (this.siteName == null && this.url == null) {
            if (this.registryURL != null) {
                try {
                    String regurl = this.registryURL.split("[, ]")[0];
                    this.url = regurl.replace("Registry?res=default_registry", "AdminService?res=default_admin");
                    this.verbose("Will try fallback admin service URL: " + this.url);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (this.url == null) {
                this.error("Either URL or site name must be given!", null);
                this.endProcessing(2);
            }
        }
        if (this.siteName != null && this.url != null) {
            this.error("URL and site name cannot both be given!", null);
            this.endProcessing(2);
        }
        AdminServiceClient asc = null;
        List availableCmds = null;
        try {
            asc = this.createClient();
            asc.getCurrentTime();
            this.verbose("Contacted admin service at <" + asc.getUrl() + ">");
            availableCmds = asc.getAdminActions();
        }
        catch (Exception ex) {
            this.error("Error contacting admin service at <" + asc.getUrl() + ">", ex);
            this.endProcessing(1);
        }
        if (!availableCmds.contains(new AdminServiceClient.AdminAction(this.cmd, null))) {
            this.error("No such command: <" + this.cmd + ">", null);
            this.endProcessing(2);
        }
        AdminServiceClient.AdminActionResult aar = null;
        try {
            aar = asc.invokeAdminAction(this.cmd, this.params);
            if (aar.successful()) {
                this.message("SUCCESS, service reply: " + aar.getMessage());
                if (aar.getResults().size() > 0) {
                    this.message(String.valueOf(aar.getResults()));
                }
            } else {
                this.message("Action was NOT SUCCESSFUL, service reply: " + aar.getMessage());
            }
        }
        catch (Exception ex) {
            this.error("Error executing admin command", ex);
            this.endProcessing(1);
        }
    }

    private AdminServiceClient createClient() throws Exception {
        if (this.url == null) {
            this.findURL();
        }
        EndpointReferenceType epr = EndpointReferenceType.Factory.newInstance();
        epr.addNewAddress().setStringValue(this.url);
        AdminServiceClient asc = new AdminServiceClient(epr, this.securityProperties);
        return asc;
    }

    private void findURL() throws Exception {
        List tsfs = this.registry.listServices(TargetSystemFactory.TSF_PORT);
        EndpointReferenceType epr = EndpointReferenceType.Factory.newInstance();
        String adminServiceURL = null;
        for (EndpointReferenceType e : tsfs) {
            String u = e.getAddress().getStringValue();
            if (!u.contains("/" + this.siteName + "/")) continue;
            epr = e;
            break;
        }
        if (epr == null) {
            throw new IllegalArgumentException("No matching site found.");
        }
        String tsfURL = epr.getAddress().getStringValue();
        int endIndex = tsfURL.lastIndexOf("TargetSystemFactoryService");
        this.url = adminServiceURL = epr.getAddress().getStringValue().substring(0, endIndex) + "AdminService?res=default_admin";
    }

    public String getName() {
        return "admin-runcommand";
    }

    public String getArgumentList() {
        return "<command> [key1=value1 key2=value2 ...]";
    }

    public String getSynopsis() {
        return "Runs a server-side administrative command, which can be parametrised, and displays the results. The mandatory '-s' option is used to select the site. ";
    }

    public String getDescription() {
        return "Run a server-side administrative command";
    }

    public String getCommandGroup() {
        return "Administration";
    }
}

