/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.admin;

import de.fzj.unicore.uas.TargetSystemFactory;
import de.fzj.unicore.ucc.actions.ListActionBase;
import de.fzj.unicore.wsrflite.xmlbeans.MetricValueDocument;
import de.fzj.unicore.wsrflite.xmlbeans.ServiceEntryDocument;
import de.fzj.unicore.wsrflite.xmlbeans.client.AdminServiceClient;
import de.fzj.unicore.wsrflite.xmlbeans.client.BaseWSRFClient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class AdminServiceInfo
extends ListActionBase<AdminServiceClient> {
    public void process() {
        super.process();
        try {
            List<AdminServiceClient> clients = this.createClients();
            for (AdminServiceClient asc : clients) {
                try {
                    this.verbose("Contacting admin service at <" + asc.getUrl() + ">");
                }
                catch (Exception ex) {
                    this.verbose("Can't access <" + asc.getUrl() + ">");
                    continue;
                }
                if (!this.filterMatch((BaseWSRFClient)asc)) continue;
                try {
                    this.list(asc);
                    ++lastNumberOfResults;
                }
                catch (Exception ex) {
                    this.error("Error showing admin service info at <" + asc.getUrl() + ">", ex);
                }
            }
        }
        catch (Exception ex) {
            this.error("Error executing admin command", ex);
            this.endProcessing(1);
        }
    }

    protected void list(AdminServiceClient asc) throws Exception {
        this.message(asc.getUrl() + " " + this.getDetails(asc));
        this.printWSRFProperties((BaseWSRFClient)asc);
    }

    protected String getDetails(AdminServiceClient asc) throws Exception {
        if (!this.detailed) {
            return "";
        }
        StringBuilder details = new StringBuilder();
        String sep = System.getProperty("line.separator");
        boolean first = true;
        for (ServiceEntryDocument.ServiceEntry e : asc.getServiceNames()) {
            if (first) {
                details.append(sep).append("  Services: ");
                first = false;
            }
            details.append(sep).append("    ");
            details.append(e.getServiceName());
            if (!e.getIsWSRF()) continue;
            details.append("[").append(e.getNumberOfInstances()).append("]");
        }
        first = true;
        MetricValueDocument.MetricValue[] monitors = asc.getMonitorMetrics();
        Arrays.sort(monitors, new MetricSorter());
        for (MetricValueDocument.MetricValue v : monitors) {
            if (first) {
                details.append(sep).append("  Monitors: ");
                first = false;
            }
            details.append(sep).append("    ");
            details.append(v.getName());
            details.append(": ").append(v.getValue()).append(" ").append(v.getUnits());
        }
        MetricValueDocument.MetricValue[] allMetrics = asc.getMetrics(null, null);
        Arrays.sort(allMetrics, new MetricSorter());
        first = true;
        for (MetricValueDocument.MetricValue v : allMetrics) {
            if (first) {
                details.append(sep).append("  Metrics: ");
                first = false;
            }
            details.append(sep).append("    ");
            details.append(v.getName());
            details.append(": ").append(v.getValue()).append(" ").append(v.getUnits());
        }
        List aCmds = asc.getAdminActions();
        if (aCmds.size() > 0) {
            details.append(sep).append("  Available commands:");
            for (AdminServiceClient.AdminAction aCmd : aCmds) {
                details.append(sep).append("    ");
                details.append(aCmd.name);
                if (aCmd.description == null) continue;
                details.append(" : ").append(aCmd.description);
            }
        }
        return details.toString();
    }

    private List<AdminServiceClient> createClients() throws Exception {
        ArrayList<AdminServiceClient> clients = new ArrayList<AdminServiceClient>();
        List<EndpointReferenceType> urls = this.findURLs();
        for (EndpointReferenceType u : urls) {
            AdminServiceClient asc = new AdminServiceClient(u, this.securityProperties);
            clients.add(asc);
        }
        return clients;
    }

    private List<EndpointReferenceType> findURLs() throws Exception {
        List tsfs = this.registry.listServices(TargetSystemFactory.TSF_PORT);
        ArrayList<EndpointReferenceType> result = new ArrayList<EndpointReferenceType>();
        for (EndpointReferenceType epr : tsfs) {
            String tsfURL = epr.getAddress().getStringValue();
            int endIndex = tsfURL.lastIndexOf("TargetSystemFactoryService");
            String adminServiceURL = epr.getAddress().getStringValue().substring(0, endIndex) + "AdminService?res=default_admin";
            EndpointReferenceType adminEPR = EndpointReferenceType.Factory.newInstance();
            adminEPR.addNewAddress().setStringValue(adminServiceURL);
            result.add(adminEPR);
        }
        return result;
    }

    public String getName() {
        return "admin-info";
    }

    public String getArgumentList() {
        return "";
    }

    public String getSynopsis() {
        return "Displays accessible AdminService instances and some information about them.";
    }

    public String getDescription() {
        return "Show accessible admin service instances and optionally detailed information about services";
    }

    public String getCommandGroup() {
        return "Administration";
    }

    private static class MetricSorter
    implements Comparator<MetricValueDocument.MetricValue> {
        private MetricSorter() {
        }

        @Override
        public int compare(MetricValueDocument.MetricValue o1, MetricValueDocument.MetricValue o2) {
            if (o1 == null || o2 == null) {
                return 0;
            }
            return o1.getName().compareTo(o2.getName());
        }
    }
}

