/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.util.httpclient;

import java.io.IOException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.URI;

public class RedirectingHttpClient
extends HttpClient {
    private boolean closeConnection;
    private int maxRedirects;
    public static final int DEFAULT_MAX_REDIRECTS = 3;
    private int redirectsCount;

    public RedirectingHttpClient() {
        this(true, 3);
    }

    public RedirectingHttpClient(boolean disableConnectionClose) {
        this(disableConnectionClose, 3);
    }

    public RedirectingHttpClient(boolean closeConnection, int maxRedirects) {
        this.maxRedirects = maxRedirects;
        this.closeConnection = closeConnection;
        this.redirectsCount = 0;
    }

    public int executeMethod(HostConfiguration hostConfig, HttpMethod method, HttpState httpState) throws IOException, HttpException {
        if (this.closeConnection) {
            method.setRequestHeader("Connection", "close");
        }
        int i = super.executeMethod(hostConfig, method, httpState);
        Header locationHeader = method.getResponseHeader("location");
        if (locationHeader != null && this.redirectsCount < this.maxRedirects) {
            String redirectLocation = locationHeader.getValue();
            method.setURI(new URI(redirectLocation, false));
            ++this.redirectsCount;
            return this.executeMethod(hostConfig, method, httpState);
        }
        this.redirectsCount = 0;
        return i;
    }
}

